/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RebaseActionHandler;
import org.eclipse.egit.ui.internal.actions.RepositoryAction;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.AbstractSharedCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.ContinueRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class RebaseAction
extends RepositoryAction
implements IWorkbenchWindowPulldownDelegate {
    private final Image rebaseSkip = UIIcons.REBASE_SKIP.createImage();
    private final Image rebaseAbort = UIIcons.REBASE_ABORT.createImage();
    private final Image rebaseContinue = UIIcons.REBASE_CONTINUE.createImage();

    public RebaseAction() {
        super("org.eclipse.egit.ui.team.Rebase", new RebaseActionHandler());
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        Repository repo = this.getRepository();
        boolean rebaseing = this.isInRebasingState(repo);
        boolean canContinue = rebaseing && this.canContinue(repo);
        this.addMenuItem(menu, UIText.RebasePulldownAction_Continue, this.rebaseContinue, new ContinueRebaseCommand(), canContinue);
        this.addMenuItem(menu, UIText.RebasePulldownAction_Skip, this.rebaseSkip, new SkipRebaseCommand(), rebaseing);
        this.addMenuItem(menu, UIText.RebasePulldownAction_Abort, this.rebaseAbort, new AbortRebaseCommand(), rebaseing);
        return menu;
    }

    public void dispose() {
        this.rebaseSkip.dispose();
        this.rebaseAbort.dispose();
        this.rebaseContinue.dispose();
        super.dispose();
    }

    @Override
    protected boolean shouldRunAction() {
        Repository repo = this.getRepository();
        return !this.isInRebasingState(repo);
    }

    private void addMenuItem(Menu parent, String itemName, Image image, AbstractRebaseCommandHandler action, boolean isEnabled) {
        MenuItem item = new MenuItem(parent, 8);
        item.setImage(image);
        item.setText(itemName);
        item.setEnabled(isEnabled);
        ExecutionEvent event = this.createExecutionEvent();
        ItemSelectionListener selectionListener = new ItemSelectionListener(action, event);
        item.addSelectionListener((SelectionListener)selectionListener);
    }

    private Repository getRepository() {
        ExecutionEvent event = this.createExecutionEvent();
        return AbstractSharedCommandHandler.getRepository(event);
    }

    private boolean isInRebasingState(Repository repo) {
        if (repo == null) {
            return false;
        }
        RepositoryState state = repo.getRepositoryState();
        return state.isRebasing();
    }

    private boolean canContinue(Repository repo) {
        IndexDiffCache diffCache = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache();
        if (diffCache != null) {
            IndexDiffCacheEntry entry = diffCache.getIndexDiffCacheEntry(repo);
            return entry != null && entry.getIndexDiff().getConflicting().isEmpty();
        }
        return false;
    }

    private static class ItemSelectionListener
    implements SelectionListener {
        private final ExecutionEvent event;
        private final AbstractRebaseCommandHandler action;

        private ItemSelectionListener(AbstractRebaseCommandHandler action, ExecutionEvent event) {
            this.event = event;
            this.action = action;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            try {
                this.action.execute(this.event);
            }
            catch (ExecutionException e) {
                Activator.logError(e.getMessage(), e);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

