/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class RepositoryTreeNodeLabelProvider
extends DecoratingStyledCellLabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final WorkbenchLabelProvider labelProvider;
    private final boolean showPaths;

    public RepositoryTreeNodeLabelProvider() {
        this(new WorkbenchLabelProvider(), null, null, false);
    }

    public RepositoryTreeNodeLabelProvider(boolean showPaths) {
        this(new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null, showPaths);
    }

    private RepositoryTreeNodeLabelProvider(WorkbenchLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext, boolean showPaths) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, decorator, decorationContext);
        this.labelProvider = labelProvider;
        this.showPaths = showPaths;
    }

    public StyledString getStyledText(Object element) {
        return super.getStyledText(element);
    }

    public String getText(Object element) {
        return this.labelProvider.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof AdditionalRefNode) {
            AdditionalRefNode additionalRefNode = (AdditionalRefNode)element;
            Ref ref = (Ref)additionalRefNode.getObject();
            return GitLabels.getRefDescription(ref);
        }
        return null;
    }

    public void update(ViewerCell cell) {
        if (this.showPaths) {
            RepositoryTreeNodeLabelProvider.update(cell, viewerCell -> super.update(viewerCell));
        } else {
            super.update(cell);
        }
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getDescription(Object element) {
        StringBuilder result = new StringBuilder(this.getText(element));
        if (element instanceof RefNode) {
            Ref ref = (Ref)((RefNode)element).getObject();
            String branchName = Repository.shortenRefName((String)ref.getName());
            result = new StringBuilder(branchName);
        }
        if (element instanceof RepositoryGroupNode) {
            RepositoryGroup group = (RepositoryGroup)((RepositoryGroupNode)element).getObject();
            result.append(" (").append(group.getRepositoryDirectories().size()).append(')');
        } else if (element instanceof RepositoryTreeNode && ((RepositoryTreeNode)element).getType() != RepositoryTreeNodeType.REPO) {
            Repository repo = ((RepositoryTreeNode)element).getRepository();
            result.append(" [").append(GitLabels.getPlainShortLabel(repo)).append(']');
        }
        return result.toString();
    }

    public void init(ICommonContentExtensionSite config) {
    }

    static void update(ViewerCell cell, Consumer<ViewerCell> updater) {
        Object element = cell.getElement();
        if (element instanceof RepositoryNode || element instanceof WorkingDirNode) {
            String textBefore = cell.getText();
            Object[] rangesBefore = cell.getStyleRanges();
            updater.accept(cell);
            String textAfter = cell.getText();
            Object[] rangesAfter = cell.getStyleRanges();
            if (textBefore.equals(textAfter) && Arrays.equals(rangesBefore, rangesAfter)) {
                return;
            }
            Repository repository = ((RepositoryTreeNode)element).getRepository();
            if (repository == null) {
                return;
            }
            String newText = " - ";
            if (element instanceof RepositoryNode) {
                newText = String.valueOf(newText) + repository.getDirectory().getAbsolutePath();
            } else if (element instanceof WorkingDirNode) {
                newText = String.valueOf(newText) + repository.getWorkTree().getAbsolutePath();
            }
            StyleRange style = new StyleRange();
            style.start = textAfter.length();
            style.length = newText.length();
            StyledString.QUALIFIER_STYLER.applyStyles((TextStyle)style);
            StyleRange[] newRanges = new StyleRange[rangesAfter.length + 1];
            System.arraycopy(rangesAfter, 0, newRanges, 0, rangesAfter.length);
            newRanges[newRanges.length - 1] = style;
            cell.setText(String.valueOf(textAfter) + newText);
            cell.setStyleRanges(newRanges);
        } else {
            updater.accept(cell);
        }
    }
}

