/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final @NonNull OCLDelegateDomain delegateDomain;
    private Operation operation = null;
    private @Nullable ExpressionInOCL query = null;

    public OCLInvocationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        assert (target != null);
        try {
            EnvironmentFactory environmentFactory = null;
            ModelManager modelManager = null;
            Executor executor = PivotUtil.basicGetExecutor((EObject)target);
            if (executor != null) {
                environmentFactory = executor.getEnvironmentFactory();
                modelManager = executor.getModelManager();
            } else {
                OCL ocl = this.delegateDomain.getOCL();
                environmentFactory = ocl.getEnvironmentFactory();
                modelManager = ocl.getModelManager();
                if (modelManager == null) {
                    modelManager = environmentFactory.createModelManager(target);
                }
            }
            MetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            ExpressionInOCL query2 = this.query;
            if (query2 == null) {
                Operation operation2 = this.operation;
                NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(this.eOperation));
                if (namedElement instanceof Operation) {
                    operation2 = this.operation = (Operation)namedElement;
                    query2 = this.query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation2);
                    InvocationBehavior.INSTANCE.validate(operation2);
                } else if (namedElement instanceof Constraint) {
                    Constraint constraint = (Constraint)namedElement;
                    query2 = this.query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
                    ValidationBehavior.INSTANCE.validate(constraint);
                } else {
                    if (namedElement != null) {
                        throw new OCLDelegateException(new SemanticException("Unsupported InvocationDelegate for a " + namedElement.eClass().getName()));
                    }
                    throw new OCLDelegateException(new SemanticException("Unsupported InvocationDelegate for a null"));
                }
            }
            return this.evaluate(environmentFactory, modelManager, target, (List<?>)arguments);
        }
        catch (EvaluationException e) {
            throw new OCLDelegateException(new EvaluationException(e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, this.operation));
        }
    }

    @Deprecated
    protected Object evaluate(@NonNull OCL ocl, @NonNull ExpressionInOCL query2, InternalEObject ecoreObject, List<?> arguments) {
        return null;
    }

    protected Object evaluate(@NonNull EnvironmentFactory environmentFactory, @NonNull ModelManager modelManager, InternalEObject ecoreObject, List<?> arguments) {
        ExpressionInOCL query2 = this.query;
        assert (query2 != null);
        IdResolver idResolver = environmentFactory.getIdResolver();
        EvaluationEnvironment evaluationEnvironment = environmentFactory.createEvaluationEnvironment(query2, modelManager);
        Object value = idResolver.boxedValueOf(ecoreObject);
        evaluationEnvironment.add(ClassUtil.nonNullModel(query2.getOwnedContext()), value);
        List<Variable> parms = query2.getOwnedParameters();
        if (!parms.isEmpty()) {
            int i = 0;
            while (i < parms.size()) {
                Object object = arguments.get(i);
                value = idResolver.boxedValueOf(object);
                evaluationEnvironment.add(ClassUtil.nonNullModel(parms.get(i)), value);
                ++i;
            }
        }
        Object boxedValue = idResolver.boxedValueOf(ecoreObject);
        VariableDeclaration contextVariable = PivotUtil.getOwnedContext(query2);
        OCLExpression expression = PivotUtil.getOwnedBody(query2);
        evaluationEnvironment.add(contextVariable, boxedValue);
        EvaluationVisitor ev = environmentFactory.createEvaluationVisitor(evaluationEnvironment);
        Object boxedResult = expression.accept(ev);
        return idResolver.ecoreValueOf(this.eOperation.getEType().getInstanceClass(), boxedResult);
    }

    public @NonNull Operation getOperation() {
        Operation operation2 = this.operation;
        if (operation2 == null) {
            NamedElement pivot = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(this.eOperation));
            if (pivot instanceof Operation) {
                operation2 = this.operation = (Operation)pivot;
            }
            if (operation2 == null) {
                throw new OCLDelegateException(new SemanticException("No pivot property for " + this.eOperation));
            }
        }
        return operation2;
    }

    public @NonNull ExpressionInOCL getQueryOrThrow(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, constraint.getContext(), "\u00abbody\u00bb"));
        }
        try {
            return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory()).parseSpecification(specification);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e);
        }
    }

    public String toString() {
        if (this.operation != null) {
            return "<" + this.delegateDomain.getURI() + ":invocation> " + this.operation;
        }
        String name = String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
        return "<" + this.delegateDomain.getURI() + ":invocation> " + name;
    }
}

