/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.editor;

import java.util.Collections;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.ResourceFilter;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.internal.ui.dialogs.FilterTreeSelectionDialog;
import org.eclipse.emf.cdo.security.internal.ui.editor.AbstractDetailsPage;
import org.eclipse.emf.cdo.security.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.security.internal.ui.util.EditableDialogCellEditor;
import org.eclipse.emf.cdo.security.internal.ui.util.INewObjectConfigurator;
import org.eclipse.emf.cdo.security.internal.ui.util.OneToManyTableBlock;
import org.eclipse.emf.cdo.security.internal.ui.util.SecurityUIUtil;
import org.eclipse.emf.cdo.security.provider.SecurityEditPlugin;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RoleDetailsPage
extends AbstractDetailsPage<Role> {
    public RoleDetailsPage(EditingDomain domain, AdapterFactory adapterFactory) {
        super(Role.class, SecurityPackage.Literals.ROLE, domain, adapterFactory);
    }

    @Override
    protected void createContents(Composite parent, FormToolkit toolkit) {
        super.createContents(parent, toolkit);
        this.text(parent, toolkit, Messages.RoleDetailsPage_0, SecurityPackage.Literals.ROLE__ID);
        this.space(parent, toolkit);
        OneToManyTableBlock perms = this.table(parent, toolkit, Messages.RoleDetailsPage_1, this.createTableConfiguration());
        perms.setNewObjectConfigurator(this.createNewPermissionConfigurator());
        this.space(parent, toolkit);
        this.oneToMany(parent, toolkit, Messages.RoleDetailsPage_2, SecurityPackage.Literals.ROLE__ASSIGNEES, SecurityPackage.Literals.GROUP);
        this.oneToMany(parent, toolkit, Messages.RoleDetailsPage_3, SecurityPackage.Literals.ROLE__ASSIGNEES, SecurityPackage.Literals.USER);
    }

    protected INewObjectConfigurator createNewPermissionConfigurator() {
        return new INewObjectConfigurator(){

            @Override
            public Command createConfigureCommand(Object newObject) {
                ResourceFilter filter = SecurityFactory.eINSTANCE.createResourceFilter("/home/${user}", PatternStyle.TREE);
                Command result = CreateChildCommand.create((EditingDomain)RoleDetailsPage.this.getEditingDomain(), (Object)newObject, (Object)new CommandParameter(newObject, (Object)SecurityPackage.Literals.FILTER_PERMISSION__FILTERS, (Object)filter), Collections.singleton(newObject));
                result = result.chain(SetCommand.create((EditingDomain)RoleDetailsPage.this.getEditingDomain(), (Object)newObject, (Object)SecurityPackage.Literals.PERMISSION__ACCESS, (Object)Access.WRITE));
                return result;
            }
        };
    }

    protected OneToManyTableBlock.ITableConfiguration createTableConfiguration() {
        return new OneToManyTableBlock.TableConfiguration(this.getManagedForm(), SecurityPackage.Literals.ROLE__PERMISSIONS, SecurityPackage.Literals.FILTER_PERMISSION){
            private static final int COL_ACCESS = 0;
            private static final int COL_PATTERN_STYLE = 1;
            private static final int COL_PATH = 2;
            private final String[] columnTitles;
            private final CellEditor[] cellEditors;
            {
                this.columnTitles = new String[]{Messages.RoleDetailsPage_5, Messages.RoleDetailsPage_6, Messages.RoleDetailsPage_7};
                this.cellEditors = new CellEditor[3];
            }

            @Override
            public String[] getColumnTitles() {
                return this.columnTitles;
            }

            @Override
            public int getColumnWeight(int index) {
                switch (index) {
                    case 0: {
                        return 15;
                    }
                    case 1: {
                        return 15;
                    }
                    case 2: {
                        return 70;
                    }
                }
                throw new IllegalArgumentException("index");
            }

            @Override
            public int getColumnMinimumSize(int index) {
                switch (index) {
                    case 0: {
                        return 30;
                    }
                    case 1: {
                        return 30;
                    }
                    case 2: {
                        return 120;
                    }
                }
                throw new IllegalArgumentException("index");
            }

            @Override
            public boolean isColumnResizable(int index) {
                switch (index) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                throw new IllegalArgumentException("index");
            }

            @Override
            public CellLabelProvider getLabelProvider(TableViewer viewer, final int columnIndex) {
                return new ColumnLabelProvider(){

                    public String getText(Object element) {
                        FilterPermission perm = (FilterPermission)element;
                        ResourceFilter filter = perm.getFilters().isEmpty() ? null : (ResourceFilter)perm.getFilters().get(0);
                        switch (columnIndex) {
                            case 0: {
                                return SecurityEditPlugin.INSTANCE.getString(String.format("_UI_Access_%s_literal", perm.getAccess()));
                            }
                            case 1: {
                                String result = "==";
                                if (filter != null && filter.getPatternStyle() != null) {
                                    switch (filter.getPatternStyle()) {
                                        case EXACT: {
                                            break;
                                        }
                                        case TREE: {
                                            result = ">=";
                                            break;
                                        }
                                        default: {
                                            result = "~=";
                                        }
                                    }
                                }
                                return result;
                            }
                            case 2: {
                                return filter == null ? "" : filter.getPath();
                            }
                        }
                        throw new IllegalArgumentException("columnIndex");
                    }
                };
            }

            @Override
            public boolean canEdit(TableViewer viewer, Object element, int columnIndex) {
                return true;
            }

            @Override
            public void setValue(TableViewer viewer, Object element, int columnIndex, Object value) {
                FilterPermission perm = (FilterPermission)element;
                ResourceFilter filter = (ResourceFilter)perm.getFilters().get(0);
                switch (columnIndex) {
                    case 0: {
                        if (perm.getAccess() == value) break;
                        RoleDetailsPage.this.execute(SetCommand.create((EditingDomain)RoleDetailsPage.this.getEditingDomain(), (Object)perm, (Object)SecurityPackage.Literals.PERMISSION__ACCESS, (Object)value));
                        viewer.refresh(element);
                        break;
                    }
                    case 1: {
                        if (filter.getPatternStyle() == value) break;
                        RoleDetailsPage.this.execute(SetCommand.create((EditingDomain)RoleDetailsPage.this.getEditingDomain(), (Object)filter, (Object)SecurityPackage.Literals.RESOURCE_FILTER__PATTERN_STYLE, (Object)value));
                        viewer.refresh(element);
                        break;
                    }
                    case 2: {
                        if (ObjectUtil.equals((Object)filter.getPath(), (Object)value)) break;
                        RoleDetailsPage.this.execute(SetCommand.create((EditingDomain)RoleDetailsPage.this.getEditingDomain(), (Object)filter, (Object)SecurityPackage.Literals.RESOURCE_FILTER__PATH, (Object)value));
                        viewer.refresh(element);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("columnIndex");
                    }
                }
            }

            @Override
            public Object getValue(TableViewer viewer, Object element, int columnIndex) {
                FilterPermission perm = (FilterPermission)element;
                ResourceFilter filter = (ResourceFilter)perm.getFilters().get(0);
                switch (columnIndex) {
                    case 0: {
                        return perm.getAccess();
                    }
                    case 1: {
                        return filter.getPatternStyle();
                    }
                    case 2: {
                        return filter.getPath();
                    }
                }
                throw new IllegalArgumentException("columnIndex");
            }

            @Override
            public CellEditor getCellEditor(TableViewer viewer, int columnIndex) {
                CellEditor result = this.cellEditors[columnIndex];
                if (result == null) {
                    this.cellEditors[columnIndex] = result = this.createCellEditor(viewer, columnIndex);
                }
                return result;
            }

            protected CellEditor createCellEditor(TableViewer viewer, int columnIndex) {
                Composite parent = (Composite)viewer.getControl();
                switch (columnIndex) {
                    case 0: {
                        ComboBoxViewerCellEditor result = new ComboBoxViewerCellEditor(parent, 12);
                        result.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(RoleDetailsPage.this.getAdapterFactory()));
                        result.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                        result.setInput((Object)Access.VALUES);
                        return result;
                    }
                    case 1: {
                        ComboBoxViewerCellEditor result = new ComboBoxViewerCellEditor(parent, 12);
                        result.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(RoleDetailsPage.this.getAdapterFactory()));
                        result.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                        result.setInput((Object)PatternStyle.VALUES);
                        return result;
                    }
                    case 2: {
                        return new EditableDialogCellEditor(parent){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                CDOResourceNode node;
                                CDOView view = ((Role)RoleDetailsPage.this.getInput()).cdoView();
                                CDOItemProvider provider = new CDOItemProvider(null, view){
                                    private boolean connected;
                                    {
                                        this.connectInput((IContainer<Object>)cDOView);
                                    }

                                    protected void connectInput(IContainer<Object> input) {
                                        if (!this.connected) {
                                            super.connectInput(input);
                                            this.connected = true;
                                        }
                                    }

                                    protected void disconnectInput(IContainer<Object> input) {
                                        if (this.connected) {
                                            this.connected = false;
                                            super.disconnectInput(input);
                                        }
                                    }
                                };
                                FilterTreeSelectionDialog dlg = new FilterTreeSelectionDialog(cellEditorWindow.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
                                dlg.setAllowMultiple(false);
                                dlg.setMessage(Messages.RoleDetailsPage_4);
                                dlg.setTitle(Messages.RoleDetailsPage_8);
                                dlg.setDoubleClickSelects(true);
                                dlg.addFilter(SecurityUIUtil.getViewerFilter(SecurityUIUtil.getTypeFilter(EresourcePackage.Literals.CDO_RESOURCE_NODE)));
                                dlg.setBlockOnOpen(true);
                                String current = (String)this.getValue();
                                dlg.setInput(view);
                                if (current != null && view.hasResource(current)) {
                                    dlg.setInitialSelection(view.getResourceNode(current));
                                }
                                String result = null;
                                if (dlg.open() == 0 && (node = (CDOResourceNode)dlg.getFirstResult()) != null) {
                                    result = node.getPath();
                                }
                                return result;
                            }
                        };
                    }
                }
                throw new IllegalArgumentException("columnIndex");
            }
        };
    }
}

