/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.DescriptionUtils;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.util.IResourceScopeCache;

@Singleton
public class DefaultResourceDescriptionManager
implements IResourceDescription.Manager {
    @Inject
    private IDefaultResourceDescriptionStrategy strategy;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private IResourceScopeCache cache = IResourceScopeCache.NullImpl.INSTANCE;
    @Inject
    private DescriptionUtils descriptionUtils;
    private static final String CACHE_KEY = DefaultResourceDescriptionManager.class.getName() + "#getResourceDescription";

    @Override
    public IResourceDescription getResourceDescription(final Resource resource) {
        return (IResourceDescription)this.cache.get((Object)CACHE_KEY, resource, (Provider)new Provider<IResourceDescription>(){

            public IResourceDescription get() {
                return DefaultResourceDescriptionManager.this.internalGetResourceDescription(resource, DefaultResourceDescriptionManager.this.strategy);
            }
        });
    }

    @Override
    public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
        return new DefaultResourceDescriptionDelta(oldDescription, newDescription);
    }

    protected IResourceDescription internalGetResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy) {
        return new DefaultResourceDescription(resource, strategy, this.cache);
    }

    public IContainer.Manager getContainerManager() {
        return this.containerManager;
    }

    public void setContainerManager(IContainer.Manager containerManager) {
        this.containerManager = containerManager;
    }

    public void setCache(IResourceScopeCache cache) {
        this.cache = cache;
    }

    public IResourceScopeCache getCache() {
        return this.cache;
    }

    @Override
    public boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate) throws IllegalArgumentException {
        if (!this.hasChanges(delta, candidate)) {
            return false;
        }
        HashSet names = Sets.newHashSet();
        this.addExportedNames(names, delta.getOld());
        this.addExportedNames(names, delta.getNew());
        return !Collections.disjoint(names, this.getImportedNames(candidate));
    }

    protected Collection<QualifiedName> getImportedNames(IResourceDescription candidate) {
        return Sets.newHashSet(candidate.getImportedNames());
    }

    protected void addExportedNames(Set<QualifiedName> names, IResourceDescription resourceDescriptor) {
        if (resourceDescriptor == null) {
            return;
        }
        Iterable<IEObjectDescription> iterable = resourceDescriptor.getExportedObjects();
        for (IEObjectDescription ieObjectDescription : iterable) {
            names.add(ieObjectDescription.getName().toLowerCase());
        }
    }

    @Override
    public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) {
        Set<URI> outgoingReferences = this.descriptionUtils.collectOutgoingReferences(candidate);
        if (!outgoingReferences.isEmpty()) {
            for (IResourceDescription.Delta delta : deltas) {
                if (!this.hasChanges(delta, candidate) || !outgoingReferences.contains(delta.getUri())) continue;
                return true;
            }
        }
        List<IContainer> containers = null;
        Collection<QualifiedName> importedNames = this.getImportedNames(candidate);
        for (IResourceDescription.Delta delta : deltas) {
            if (!this.hasChanges(delta, candidate)) continue;
            URI uri = delta.getUri();
            if ((uri.isPlatform() || uri.isArchive()) && delta.getNew() != null) {
                if (containers == null) {
                    containers = this.containerManager.getVisibleContainers(candidate, context);
                }
                boolean descriptionIsContained = false;
                for (int i = 0; i < containers.size() && !descriptionIsContained; ++i) {
                    descriptionIsContained = containers.get(i).hasResourceDescription(uri);
                }
                if (!descriptionIsContained) {
                    return false;
                }
            }
            if (!this.isAffected(importedNames, delta.getNew()) && !this.isAffected(importedNames, delta.getOld())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasChanges(IResourceDescription.Delta delta, IResourceDescription candidate) {
        return delta.haveEObjectDescriptionsChanged();
    }

    protected boolean isAffected(Collection<QualifiedName> importedNames, IResourceDescription description) {
        if (description != null) {
            for (IEObjectDescription desc : description.getExportedObjects()) {
                if (!importedNames.contains(desc.getName().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public DescriptionUtils getDescriptionUtils() {
        return this.descriptionUtils;
    }

    public void setDescriptionUtils(DescriptionUtils descriptionUtils) {
        this.descriptionUtils = descriptionUtils;
    }

    public void setStrategy(IDefaultResourceDescriptionStrategy strategy) {
        this.strategy = strategy;
    }
}

