/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class SelfAttachingContainerListener
implements IListener {
    public void attach(Object element) {
        block7: {
            if (this.shouldAttach(element)) {
                EventUtil.addListener(element, this);
                if (this.shouldDescend(element)) {
                    try {
                        Object[] children = ContainerUtil.getElements(element);
                        if (children == null) break block7;
                        Object[] objectArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            try {
                                this.attach(child);
                            }
                            catch (Exception ex) {
                                this.handleException(ex);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        this.handleException(ex);
                    }
                }
            }
        }
    }

    public void detach(Object element) {
        if (this.shouldAttach(element)) {
            block7: {
                if (this.shouldDescend(element)) {
                    try {
                        Object[] children = ContainerUtil.getElements(element);
                        if (children == null) break block7;
                        Object[] objectArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            try {
                                this.detach(child);
                            }
                            catch (Exception ex) {
                                this.handleException(ex);
                            }
                            ++n2;
                        }
                    }
                    catch (Exception ex) {
                        this.handleException(ex);
                    }
                }
            }
            EventUtil.removeListener(element, this);
        }
    }

    @Override
    public void notifyEvent(IEvent event) {
        if (event instanceof IContainerEvent) {
            this.notifyContainerEvent((IContainerEvent)event);
        } else {
            this.notifyOtherEvent(event);
        }
    }

    protected void notifyContainerEvent(IContainerEvent<?> event) {
        IContainerDelta<?>[] iContainerDeltaArray = event.getDeltas();
        int n = iContainerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainerDelta<?> delta = iContainerDeltaArray[n2];
            final Object element = delta.getElement();
            if (delta.getKind() == IContainerDelta.Kind.ADDED) {
                if (this.isWaitForActive() && !this.isActive(element)) {
                    EventUtil.addListener(element, new LifecycleEventAdapter(){

                        @Override
                        protected void onActivated(ILifecycle lifecycle) {
                            lifecycle.removeListener(this);
                            SelfAttachingContainerListener.this.attach(element);
                        }
                    });
                } else {
                    this.attach(element);
                }
            } else {
                this.detach(element);
            }
            ++n2;
        }
    }

    protected void notifyOtherEvent(IEvent event) {
    }

    protected boolean shouldAttach(Object element) {
        return true;
    }

    protected boolean shouldDescend(Object element) {
        return !(element instanceof DoNotDescend);
    }

    protected boolean isWaitForActive() {
        return true;
    }

    protected boolean isActive(Object element) {
        return LifecycleUtil.isActive(element);
    }

    protected void handleException(Exception ex) {
    }

    public static class Delegating
    extends SelfAttachingContainerListener {
        private final IListener delegate;
        private final boolean delegateContainerEvents;

        public Delegating(IListener delegate, boolean delegateContainerEvents) {
            this.delegate = delegate;
            this.delegateContainerEvents = delegateContainerEvents;
        }

        public Delegating(IListener delegate) {
            this(delegate, false);
        }

        @Override
        protected void notifyContainerEvent(IContainerEvent<?> event) {
            super.notifyContainerEvent(event);
            if (this.delegateContainerEvents) {
                this.delegate.notifyEvent(event);
            }
        }

        @Override
        protected void notifyOtherEvent(IEvent event) {
            this.delegate.notifyEvent(event);
        }
    }

    public static interface DoNotDescend {
    }
}

