/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class Row
implements SearchRow {
    public static final int MEMORY_CALCULATE = -1;
    public static final Row[] EMPTY_ARRAY = new Row[0];
    private long key;
    private final Value[] data;
    private int memory;
    private int version;
    private boolean deleted;
    private int sessionId;

    public Row(Value[] valueArray, int n) {
        this.data = valueArray;
        this.memory = n;
    }

    public Row getCopy() {
        Value[] valueArray = new Value[this.data.length];
        System.arraycopy(this.data, 0, valueArray, 0, this.data.length);
        Row row = new Row(valueArray, this.memory);
        row.key = this.key;
        row.version = this.version + 1;
        row.sessionId = this.sessionId;
        return row;
    }

    public void setKeyAndVersion(SearchRow searchRow) {
        this.setKey(searchRow.getKey());
        this.setVersion(searchRow.getVersion());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long l) {
        this.key = l;
    }

    public Value getValue(int n) {
        return n == -1 ? ValueLong.get(this.key) : this.data[n];
    }

    public int getByteCount(Data data) {
        int n = 0;
        for (Value value : this.data) {
            n += data.getValueLen(value);
        }
        return n;
    }

    public void setValue(int n, Value value) {
        if (n == -1) {
            this.key = value.getLong();
        } else {
            this.data[n] = value;
        }
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int n = 40;
        if (this.data != null) {
            int n2 = this.data.length;
            n += 24 + n2 * 8;
            for (int i = 0; i < n2; ++i) {
                Value value = this.data[i];
                if (value == null) continue;
                n += value.getMemory();
            }
        }
        this.memory = n;
        return n;
    }

    public String toString() {
        StatementBuilder statementBuilder = new StatementBuilder("( /* key:");
        statementBuilder.append(this.getKey());
        if (this.version != 0) {
            statementBuilder.append(" v:" + this.version);
        }
        if (this.isDeleted()) {
            statementBuilder.append(" deleted");
        }
        statementBuilder.append(" */ ");
        if (this.data != null) {
            for (Value value : this.data) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(value == null ? "null" : value.getTraceSQL());
            }
        }
        return statementBuilder.append(')').toString();
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void commit() {
        this.sessionId = 0;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

