/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.impl.PLAFDetector;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public final class SortIconFactory {
    private static final String resourceRoot = "resources";
    private static final String defaultResourcePath = "aqua";
    private static final Map<String, String> lookAndFeelResourcePathMap = new HashMap<String, String>();
    private static Icon[] defaultIcons;
    private static String[] iconFileNames;

    private SortIconFactory() {
        throw new UnsupportedOperationException();
    }

    public static Icon[] loadIcons() {
        if (defaultIcons != null) {
            return defaultIcons;
        }
        String lookAndFeelName = UIManager.getLookAndFeel().getName();
        if (lookAndFeelName.equals("Metal")) {
            lookAndFeelName = PLAFDetector.getMetalTheme();
        } else if (lookAndFeelName.equals("Windows")) {
            lookAndFeelName = PLAFDetector.getWindowsTheme();
        }
        String resourcePath = lookAndFeelResourcePathMap.get(lookAndFeelName);
        if (resourcePath == null) {
            resourcePath = defaultResourcePath;
        }
        defaultIcons = SortIconFactory.loadIcons("resources/" + resourcePath);
        return defaultIcons;
    }

    public static Icon[] loadIcons(String path) {
        ClassLoader jarLoader = SortIconFactory.class.getClassLoader();
        Icon[] pathIcons = new Icon[iconFileNames.length];
        for (int i = 1; i < pathIcons.length; ++i) {
            URL iconLocation = jarLoader.getResource(path + "/" + iconFileNames[i]);
            if (iconLocation == null) continue;
            pathIcons[i] = new ImageIcon(iconLocation);
        }
        return pathIcons;
    }

    static {
        lookAndFeelResourcePathMap.put("Mac OS X Aqua", defaultResourcePath);
        lookAndFeelResourcePathMap.put("Metal/Steel", "metal");
        lookAndFeelResourcePathMap.put("Metal/Ocean", "ocean");
        lookAndFeelResourcePathMap.put("Classic Windows", "windows");
        lookAndFeelResourcePathMap.put("Windows XP", "windowsxp");
        lookAndFeelResourcePathMap.put("Windows Vista", "windowsxp");
        lookAndFeelResourcePathMap.put("WinLAF", "windowsxp");
        defaultIcons = null;
        iconFileNames = new String[]{"unsorted.png", "primary_sorted.png", "primary_sorted_reverse.png", "primary_sorted_alternate.png", "primary_sorted_alternate_reverse.png", "secondary_sorted.png", "secondary_sorted_reverse.png", "secondary_sorted_alternate.png", "secondary_sorted_alternate_reverse.png"};
    }
}

