/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.impl;

import java.io.IOException;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystemProvider;
import org.apache.sshd.client.subsystem.sftp.impl.DefaultSftpClient;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultSftpClientFactory
extends AbstractLoggingBean
implements SftpClientFactory {
    public static final DefaultSftpClientFactory INSTANCE = new DefaultSftpClientFactory();

    @Override
    public SftpClient createSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        DefaultSftpClient client = this.createDefaultSftpClient(session, selector);
        try {
            client.negotiateVersion(selector);
        }
        catch (IOException | RuntimeException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSftpClient({}) failed ({}) to negotiate version: {}", new Object[]{session, e.getClass().getSimpleName(), e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("createSftpClient(" + session + ") version negotiation failure details", (Throwable)e);
            }
            client.close();
            throw e;
        }
        return client;
    }

    protected DefaultSftpClient createDefaultSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        return new DefaultSftpClient(session);
    }

    @Override
    public SftpFileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        ClientFactoryManager manager = session.getFactoryManager();
        SftpFileSystemProvider provider = new SftpFileSystemProvider((SshClient)manager, selector);
        SftpFileSystem fs = provider.newFileSystem(session);
        fs.setReadBufferSize(readBufferSize);
        fs.setWriteBufferSize(writeBufferSize);
        return fs;
    }
}

