/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.subsystem.sftp.extensions;

import java.util.Collection;
import org.apache.sshd.common.subsystem.sftp.extensions.AbstractParser;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class SupportedParser
extends AbstractParser<Supported> {
    public static final SupportedParser INSTANCE = new SupportedParser();

    public SupportedParser() {
        super("supported");
    }

    @Override
    public Supported parse(byte[] input, int offset, int len) {
        return this.parse((Buffer)new ByteArrayBuffer(input, offset, len));
    }

    public Supported parse(Buffer buffer) {
        Supported sup = new Supported();
        sup.supportedAttributeMask = buffer.getInt();
        sup.supportedAttributeBits = buffer.getInt();
        sup.supportedOpenFlags = buffer.getInt();
        sup.supportedAccessMask = buffer.getInt();
        sup.maxReadSize = buffer.getInt();
        sup.extensionNames = buffer.getStringList(false);
        return sup;
    }

    public static class Supported {
        public int supportedAttributeMask;
        public int supportedAttributeBits;
        public int supportedOpenFlags;
        public int supportedAccessMask;
        public int maxReadSize;
        public Collection<String> extensionNames;

        public String toString() {
            return "attrsMask=0x" + Integer.toHexString(this.supportedAttributeMask) + ",attrsBits=0x" + Integer.toHexString(this.supportedAttributeBits) + ",openFlags=0x" + Integer.toHexString(this.supportedOpenFlags) + ",accessMask=0x" + Integer.toHexString(this.supportedAccessMask) + ",maxReadSize=" + this.maxReadSize + ",extensions=" + this.extensionNames;
        }
    }
}

