/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.GenericUtils;

public interface SessionHeartbeatController
extends PropertyResolver {
    public static final String SESSION_HEARTBEAT_TYPE = "session-connection-heartbeat-type";
    public static final String SESSION_HEARTBEAT_INTERVAL = "session-connection-heartbeat-interval";
    public static final long DEFAULT_CONNECTION_HEARTBEAT_INTERVAL = 0L;

    default public HeartbeatType getSessionHeartbeatType() {
        Object value = this.getObject(SESSION_HEARTBEAT_TYPE);
        return PropertyResolverUtils.toEnum(HeartbeatType.class, value, false, HeartbeatType.VALUES);
    }

    default public long getSessionHeartbeatInterval() {
        return this.getLongProperty(SESSION_HEARTBEAT_INTERVAL, 0L);
    }

    default public void disableSessionHeartbeat() {
        this.setSessionHeartbeat(HeartbeatType.NONE, TimeUnit.MILLISECONDS, 0L);
    }

    default public void setSessionHeartbeat(HeartbeatType type, TimeUnit unit, long count) {
        Objects.requireNonNull(type, "No heartbeat type specified");
        Objects.requireNonNull(unit, "No heartbeat time unit provided");
        PropertyResolverUtils.updateProperty((PropertyResolver)this, SESSION_HEARTBEAT_TYPE, (Object)type);
        PropertyResolverUtils.updateProperty((PropertyResolver)this, SESSION_HEARTBEAT_INTERVAL, TimeUnit.MILLISECONDS.convert(count, unit));
    }

    public static enum HeartbeatType {
        NONE,
        IGNORE,
        RESERVED;

        public static final Set<HeartbeatType> VALUES;

        public static HeartbeatType fromName(String name) {
            return GenericUtils.isEmpty(name) ? null : (HeartbeatType)VALUES.stream().filter(v -> name.equalsIgnoreCase(v.name())).findAny().orElse(null);
        }

        static {
            VALUES = EnumSet.allOf(HeartbeatType.class);
        }
    }
}

