/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.LazyStartHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class UpdateActivationResolution
extends AbstractManifestMarkerResolution {
    private String fHeader = null;

    public UpdateActivationResolution(int type, String currentHeader, IMarker marker) {
        super(type, marker);
        this.fHeader = currentHeader;
    }

    @Override
    protected void createChange(BundleModel model) {
        this.fHeader = this.marker.getAttribute("deprecatedAutostart.header", "Eclipse-AutoStart");
        if (TargetPlatformHelper.getTargetVersion() >= 3.4) {
            LazyStartHeader header = (LazyStartHeader)model.getBundle().getManifestHeader(this.fHeader);
            if (header != null) {
                LazyStartHeader newHeader = (LazyStartHeader)model.getFactory().createHeader("Bundle-ActivationPolicy", "lazy");
                newHeader.setLazyStart(header.isLazyStart());
                String excludes = header.getAttribute("exceptions");
                if (excludes != null) {
                    String directive = header.isLazyStart() ? "exclude" : "include";
                    newHeader.setDirective(directive, excludes);
                    if (!header.isLazyStart()) {
                        newHeader.setLazyStart(true);
                    }
                }
                newHeader.setOffset(header.getOffset());
                newHeader.setLength(header.getLength());
                Bundle bundle = (Bundle)model.getBundle();
                Map map = bundle.getHeaders();
                map.remove(this.fHeader);
                map.put("Bundle-ActivationPolicy", newHeader);
                model.fireModelObjectChanged((Object)newHeader, "Bundle-ActivationPolicy", null, (Object)header.getValue());
            }
        } else {
            model.getBundle().renameHeader("Eclipse-AutoStart", "Eclipse-LazyStart");
        }
    }

    @Override
    public String getDescription() {
        if (TargetPlatformHelper.getTargetVersion() >= 3.4) {
            return PDEUIMessages.UpdateActivationResolution_bundleActivationPolicy_label;
        }
        return PDEUIMessages.UpdateActivationResolution_lazyStart_label;
    }

    public String getLabel() {
        if (TargetPlatformHelper.getTargetVersion() >= 3.4) {
            return NLS.bind((String)PDEUIMessages.UpdateActivationResolution_bundleActivationPolicy_desc, (Object)this.fHeader);
        }
        return PDEUIMessages.UpdateActivationResolution_lazyStart_desc;
    }
}

