/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.data;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.data.VMTypeData;
import org.eclipse.ocl.examples.debug.vm.data.VMValueData;

public class VMVariableData
implements Serializable {
    private static final long serialVersionUID = 1038270932235501034L;
    public static final int LOCAL = 0;
    public static final int ATTRIBUTE = 1;
    public static final int REFERENCE = 2;
    public static final int PREDEFINED_VAR = 3;
    public static final int MODEL_PARAMETER = 4;
    public static final int INTERM_PROPERTY = 5;
    public static final int COLLECTION_ELEMENT = 6;
    public final @NonNull String name;
    public final @Nullable String variableURI;
    public VMValueData value;
    public Object valueObject;
    public VMTypeData type;
    public int kind;

    public static @NonNull String toKindString(int kind) {
        switch (kind) {
            case 0: {
                return "LOCAL";
            }
            case 1: {
                return "ATTRIBUTE";
            }
            case 2: {
                return "REFERENCE";
            }
            case 3: {
                return "PREDEFINED_VAR";
            }
            case 4: {
                return "MODEL_PARAMETER";
            }
            case 5: {
                return "INTERM_PROPERTY";
            }
            case 6: {
                return "COLLECTION_ELEMENT";
            }
        }
        return "???";
    }

    public VMVariableData(@NonNull String name, @Nullable String variableURI) {
        this.name = name;
        this.variableURI = variableURI;
    }

    public boolean isRootVariable() {
        return this.variableURI == null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("(").append(VMVariableData.toKindString(this.kind));
        s.append(",").append(this.variableURI);
        s.append(",").append(this.name);
        s.append(":").append(this.type);
        s.append("=").append(this.valueObject);
        s.append(")");
        return s.toString();
    }
}

