/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.NodeFinder;
import org.eclipse.text.edits.TextEdit;

public class UpdateSinceTagOperation {
    private IMarker fMarker;
    private IMarker[] otherIMarkers;
    private int sinceTagType;
    private String sinceTagVersion;

    public UpdateSinceTagOperation(IMarker marker, IMarker[] otherMarkers, int sinceTagType, String sinceTagVersion) {
        this.fMarker = marker;
        this.otherIMarkers = otherMarkers;
        if (this.otherIMarkers == null) {
            this.otherIMarkers = new IMarker[0];
        }
        this.sinceTagType = sinceTagType;
        this.sinceTagVersion = sinceTagVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (monitor != null) {
            monitor.beginTask(MarkerMessages.UpdateSinceTagOperation_title, 3);
        }
        try {
            Integer charStartAttribute = (Integer)this.fMarker.getAttribute("charStart");
            int intValue = charStartAttribute;
            IJavaElement javaElement = null;
            IJavaElement handleElement = null;
            IResource resource = null;
            if (intValue > 0) {
                resource = this.fMarker.getResource();
                javaElement = JavaCore.create((IResource)resource);
            } else {
                String handle = (String)this.fMarker.getAttribute("org.eclipse.jdt.internal.core.JavaModelManager.handleId");
                if (handle != null) {
                    handleElement = JavaCore.create((String)handle);
                }
                if (handleElement != null && handleElement.exists()) {
                    javaElement = handleElement.getAncestor(5);
                }
            }
            if (javaElement == null || javaElement.getElementType() != 5) return;
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
            if (!compilationUnit.isWorkingCopy()) {
                JavaUI.openInEditor((IJavaElement)compilationUnit);
            }
            ASTParser parser = ASTParser.newParser((int)14);
            parser.setSource(compilationUnit);
            if (intValue <= 0) {
                if (!(handleElement instanceof IMember)) return;
                IMember member = (IMember)handleElement;
                ISourceRange range = member.getNameRange();
                if (range != null) {
                    intValue = range.getOffset();
                } else {
                    range = member.getSourceRange();
                    if (range == null || range.getOffset() <= 0) return;
                    intValue = range.getOffset();
                }
            }
            try {
                parser.setFocalPosition(intValue);
                parser.setResolveBindings(true);
                Map options = compilationUnit.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                parser.setCompilerOptions(options);
                CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                BodyDeclaration node = null;
                NodeFinder nodeFinder = new NodeFinder(intValue);
                unit.accept((ASTVisitor)nodeFinder);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if ((node = nodeFinder.getNode()) == null) return;
                unit.recordModifications();
                AST ast = unit.getAST();
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                this.processNode(unit, rewrite, node);
                IMarker[] iMarkerArray = this.otherIMarkers;
                int n = this.otherIMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker iMarker = iMarkerArray[n2];
                    BodyDeclaration node2 = null;
                    IResource otherResource = iMarker.getResource();
                    if (otherResource.equals((Object)resource)) {
                        Integer charStartAttribute2 = (Integer)iMarker.getAttribute("charStart");
                        int intValue2 = charStartAttribute2;
                        NodeFinder nodeFinder2 = new NodeFinder(intValue2);
                        unit.accept((ASTVisitor)nodeFinder2);
                        if (monitor != null) {
                            monitor.worked(1);
                        }
                        if (node != (node2 = nodeFinder2.getNode())) {
                            this.processNode(unit, rewrite, node2);
                        }
                    }
                    ++n2;
                }
                try {
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    TextEdit edit = rewrite.rewriteAST();
                    compilationUnit.applyTextEdit(edit, monitor);
                    if (monitor == null) return;
                    monitor.worked(1);
                    return;
                }
                finally {
                    compilationUnit.reconcile(0, false, null, null);
                }
            }
            catch (CoreException e) {
                ApiUIPlugin.log(e);
            }
            return;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void processNode(CompilationUnit unit, ASTRewrite rewrite, BodyDeclaration node) {
        AST ast = unit.getAST();
        if (3 == this.sinceTagType) {
            Javadoc docnode = node.getJavadoc();
            if (docnode == null) {
                docnode = ast.newJavadoc();
                rewrite.set((ASTNode)node, (StructuralPropertyDescriptor)node.getJavadocProperty(), (Object)docnode, null);
            } else {
                List tags = docnode.tags();
                boolean found = false;
                for (TagElement element : tags) {
                    String tagName = element.getTagName();
                    if (!"@since".equals(tagName)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return;
                }
            }
            ListRewrite lrewrite = rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
            TagElement newtag = ast.newTagElement();
            newtag.setTagName("@since");
            TextElement textElement = ast.newTextElement();
            textElement.setText(this.sinceTagVersion);
            newtag.fragments().add(textElement);
            lrewrite.insertLast((ASTNode)newtag, null);
        } else {
            Javadoc docnode = node.getJavadoc();
            List tags = docnode.tags();
            TagElement sinceTag = null;
            for (TagElement tagElement : tags) {
                if (!"@since".equals(tagElement.getTagName())) continue;
                sinceTag = tagElement;
                break;
            }
            if (sinceTag != null) {
                List fragments = sinceTag.fragments();
                if (fragments.size() >= 1) {
                    TextElement textElement = (TextElement)fragments.get(0);
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(' ').append(this.sinceTagVersion);
                    rewrite.set((ASTNode)textElement, (StructuralPropertyDescriptor)TextElement.TEXT_PROPERTY, (Object)String.valueOf(buffer), null);
                } else {
                    ListRewrite lrewrite = rewrite.getListRewrite((ASTNode)docnode, Javadoc.TAGS_PROPERTY);
                    TagElement newtag = ast.newTagElement();
                    newtag.setTagName("@since");
                    TextElement textElement = ast.newTextElement();
                    textElement.setText(this.sinceTagVersion);
                    newtag.fragments().add(textElement);
                    lrewrite.replace((ASTNode)sinceTag, (ASTNode)newtag, null);
                }
            }
        }
    }
}

