/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IMethod method) {
        try {
            return BasicElementLabels.getJavaElementName(Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (!method.isConstructor() ? 1 : 0) != 0));
        }
        catch (JavaModelException javaModelException) {
            return BasicElementLabels.getJavaElementName(method.getElementName());
        }
    }

    public static String createFieldSignature(IField field) {
        return BasicElementLabels.getJavaElementName(String.valueOf(field.getDeclaringType().getFullyQualifiedName('.')) + "." + field.getElementName());
    }

    public static String createSignature(IMember member) {
        switch (member.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)member);
            }
            case 7: {
                return BasicElementLabels.getJavaElementName(((IType)member).getFullyQualifiedName('.'));
            }
            case 10: {
                return RefactoringCoreMessages.JavaElementUtil_initializer;
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IMethod)member);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IJavaElement[] getElementsOfType(IJavaElement[] elements, int type) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(elements.length);
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element.getElementType() == type) {
                result.add(element);
            }
            ++n2;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IType getMainType(ICompilationUnit cu) throws JavaModelException {
        IType[] iTypeArray = cu.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (JavaElementUtil.isMainType(type)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isMainType(IType type) throws JavaModelException {
        if (!type.exists()) {
            return false;
        }
        if (type.isBinary()) {
            return false;
        }
        if (type.getCompilationUnit() == null) {
            return false;
        }
        if (type.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(type) || JavaElementUtil.isCuOnlyType(type);
    }

    private static boolean isPrimaryType(IType type) {
        return type.equals(type.getCompilationUnit().findPrimaryType());
    }

    private static boolean isCuOnlyType(IType type) throws JavaModelException {
        return type.getCompilationUnit().getTypes().length == 1;
    }

    public static boolean isAncestorOf(IJavaElement ancestor, IJavaElement child) {
        IJavaElement parent = child.getParent();
        while (parent != null && !parent.equals(ancestor)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public static IMethod[] getAllConstructors(IType type) throws JavaModelException {
        if (JavaModelUtil.isInterfaceOrAnnotation(type)) {
            return new IMethod[0];
        }
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod iMethod = iMethodArray[n2];
            if (iMethod.isConstructor()) {
                result.add(iMethod);
            }
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IJavaProject[] getReferencingProjects(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry cpe = root.getRawClasspathEntry();
        if (cpe.getEntryKind() == 1) {
            cpe = root.getResolvedClasspathEntry();
        }
        IJavaProject[] allJavaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(allJavaProjects.length);
        IJavaProject[] iJavaProjectArray = allJavaProjects;
        int n = allJavaProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(cpe);
            if (roots.length > 0) {
                result.add(project);
            }
            ++n2;
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        IMember member;
        ArrayList<IMember> result = new ArrayList<IMember>(a1.length + a2.length);
        IMember[] iMemberArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            member = iMemberArray[n2];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++n2;
        }
        iMemberArray = a2;
        n = a2.length;
        n2 = 0;
        while (n2 < n) {
            member = iMemberArray[n2];
            if (!result.contains(member)) {
                result.add(member);
            }
            ++n2;
        }
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }

    public static IPackageFragment[] getPackageAndSubpackages(IPackageFragment pack) throws JavaModelException {
        if (pack.isDefaultPackage()) {
            return new IPackageFragment[]{pack};
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        ArrayList<IPackageFragment> subpackages = new ArrayList<IPackageFragment>();
        subpackages.add(pack);
        String prefix = String.valueOf(pack.getElementName()) + '.';
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement packageFragment = iJavaElementArray[n2];
            IPackageFragment currentPackage = (IPackageFragment)packageFragment;
            if (currentPackage.getElementName().startsWith(prefix)) {
                subpackages.add(currentPackage);
            }
            ++n2;
        }
        return subpackages.toArray(new IPackageFragment[subpackages.size()]);
    }

    public static IPackageFragment getParentSubpackage(IPackageFragment pack) {
        String newPackageName;
        if (pack.isDefaultPackage()) {
            return null;
        }
        int index = pack.getElementName().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pack.getParent();
        IPackageFragment parent = root.getPackageFragment(newPackageName = pack.getElementName().substring(0, index));
        if (parent.exists()) {
            return parent;
        }
        return null;
    }

    public static IMember[] sortByOffset(IMember[] members) {
        Comparator comparator = (o1, o2) -> {
            try {
                return o1.getNameRange().getOffset() - o2.getNameRange().getOffset();
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        };
        Arrays.sort(members, comparator);
        return members;
    }

    public static boolean isSourceAvailable(ISourceReference sourceReference) {
        try {
            return SourceRange.isAvailable((ISourceRange)sourceReference.getSourceRange());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

