/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.jdbc.DelegatingPreparedStatement;
import org.eclipse.net4j.internal.db.DBConnection;
import org.eclipse.net4j.internal.db.DBResultSet;

public class DBPreparedStatement
extends DelegatingPreparedStatement
implements IDBPreparedStatement {
    private final String sql;
    private final IDBPreparedStatement.ReuseProbability reuseProbability;
    private int touch;
    private DBPreparedStatement nextCached;
    private Object schemaAccessToken;

    public DBPreparedStatement(DBConnection transaction, String sql, IDBPreparedStatement.ReuseProbability reuseProbability, PreparedStatement delegate) {
        super(delegate, (Connection)transaction);
        this.sql = sql;
        this.reuseProbability = reuseProbability;
    }

    @Override
    public DBConnection getConnection() throws SQLException {
        return (DBConnection)super.getConnection();
    }

    @Override
    @Deprecated
    public DBConnection getTransaction() {
        try {
            return this.getConnection();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public IDBPreparedStatement.ReuseProbability getReuseProbability() {
        return this.reuseProbability;
    }

    public void setTouch(int touch) {
        this.touch = touch;
    }

    public DBPreparedStatement getNextCached() {
        return this.nextCached;
    }

    public void setNextCached(DBPreparedStatement nextCached) {
        this.nextCached = nextCached;
    }

    @Override
    public int compareTo(IDBPreparedStatement o) {
        int result = this.reuseProbability.compareTo(o.getReuseProbability());
        if (result == 0) {
            result = ((DBPreparedStatement)o).touch - this.touch;
        }
        return result;
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public void close() throws SQLException {
        this.getConnection().releasePreparedStatement(this);
    }

    @Override
    public IDBResultSet getGeneratedKeys() throws SQLException {
        return new DBResultSet(this.getDelegate().getGeneratedKeys(), this);
    }

    @Override
    public IDBResultSet getResultSet() throws SQLException {
        return new DBResultSet(this.getDelegate().getResultSet(), this);
    }

    @Override
    public IDBResultSet executeQuery() throws SQLException {
        return new DBResultSet(this.getDelegate().executeQuery(), this);
    }

    @Override
    @Deprecated
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        value = this.getConnection().convertString(this, parameterIndex, value);
        super.setString(parameterIndex, value);
    }

    public String convertString(DBResultSet resultSet, int columnIndex, String value) throws SQLException {
        return this.getConnection().convertString(resultSet, columnIndex, value);
    }

    public String convertString(DBResultSet resultSet, String columnLabel, String value) throws SQLException {
        return this.getConnection().convertString(resultSet, columnLabel, value);
    }

    Object setSchemaAccessToken(Object schemaAccessToken) {
        Object oldSchemaAccessToken = this.schemaAccessToken;
        this.schemaAccessToken = schemaAccessToken;
        return oldSchemaAccessToken;
    }
}

