/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.compare;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.compare.CDOComparisonScope;
import org.eclipse.emf.cdo.internal.compare.CDOCompareFactoryImpl;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDOCompare {
    private static final boolean IGNORE_RCP_REGISTRIES = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.compare.CDOCompare.IGNORE_RCP_REGISTRIES");
    private static final boolean USE_RCP_REGISTRIES;

    static {
        if (IGNORE_RCP_REGISTRIES) {
            USE_RCP_REGISTRIES = false;
        } else {
            boolean rcpRegistriesAvailable = false;
            try {
                rcpRegistriesAvailable = CommonPlugin.loadClass((String)"org.eclipse.emf.compare.rcp", (String)"org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin") != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            USE_RCP_REGISTRIES = rcpRegistriesAvailable;
        }
        EFactory factory = ComparePackage.eINSTANCE.getEFactoryInstance();
        if (factory == null || factory.getClass() != CDOCompareFactoryImpl.class) {
            ComparePackage.eINSTANCE.setEFactoryInstance((EFactory)CDOCompareFactoryImpl.getInstance());
        }
    }

    public Comparison compare(IComparisonScope scope) {
        CDOIDFunction idFunction = this.createIDFunction();
        IdentifierEObjectMatcher matcher = this.createMatcher(idFunction);
        IEqualityHelperFactory equalityHelperFactory = this.createEqualityHelperFactory();
        IComparisonFactory comparisonFactory = this.createComparisonFactory(equalityHelperFactory);
        EMFCompare comparator = this.createComparator((IEObjectMatcher)matcher, comparisonFactory);
        return comparator.compare(scope);
    }

    protected CDOIDFunction createIDFunction() {
        return new CDOIDFunction();
    }

    protected IdentifierEObjectMatcher createMatcher(Function<EObject, String> idFunction) {
        return new CDOMatcher(idFunction);
    }

    protected IEqualityHelperFactory createEqualityHelperFactory() {
        return new DefaultEqualityHelperFactory();
    }

    protected IComparisonFactory createComparisonFactory(IEqualityHelperFactory equalityHelperFactory) {
        return new DefaultComparisonFactory(equalityHelperFactory);
    }

    protected EMFCompare.Builder createComparatorBuilder() {
        EMFCompare.Builder builder = EMFCompare.builder();
        if (USE_RCP_REGISTRIES) {
            EMFCompareBuilderConfigurator configurator = EMFCompareBuilderConfigurator.createDefault();
            configurator.configure(builder);
        }
        return builder;
    }

    protected EMFCompare createComparator(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        IConflictDetector conflictDetector;
        IPostProcessor.Descriptor.Registry<?> registry;
        IEquiEngine equiEngine;
        IReqEngine reqEngine;
        IDiffEngine diffEngine;
        EMFCompare.Builder builder = this.createComparatorBuilder();
        IMatchEngine.Factory.Registry matchEngineFactoryRegistry = this.createMatchEngineFactoryRegistry(matcher, comparisonFactory);
        if (matchEngineFactoryRegistry != null) {
            builder.setMatchEngineFactoryRegistry(matchEngineFactoryRegistry);
        }
        if ((diffEngine = this.createDiffEngine()) != null) {
            builder.setDiffEngine(diffEngine);
        }
        if ((reqEngine = this.createRequirementEngine()) != null) {
            builder.setRequirementEngine(reqEngine);
        }
        if ((equiEngine = this.createEquivalenceEngine()) != null) {
            builder.setEquivalenceEngine(equiEngine);
        }
        if ((registry = this.createPostProcessorRegistry()) != null) {
            builder.setPostProcessorRegistry(registry);
        }
        if ((conflictDetector = this.createConflictDetector()) != null) {
            builder.setConflictDetector(conflictDetector);
        }
        return builder.build();
    }

    protected IMatchEngine.Factory.Registry createMatchEngineFactoryRegistry(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        MatchEngineFactoryRegistryImpl registry = new MatchEngineFactoryRegistryImpl();
        registry.add((IMatchEngine.Factory)new CDOMatchEngine.Factory(matcher, comparisonFactory));
        return registry;
    }

    protected IDiffEngine createDiffEngine() {
        return new CDODiffEngine();
    }

    protected IReqEngine createRequirementEngine() {
        return null;
    }

    protected IEquiEngine createEquivalenceEngine() {
        return null;
    }

    protected IPostProcessor.Descriptor.Registry<?> createPostProcessorRegistry() {
        return null;
    }

    protected IConflictDetector createConflictDetector() {
        return null;
    }

    public static IComparisonScope getScope(Comparison comparison) {
        return (IComparisonScope)EMFUtil.getAdapter((Notifier)comparison, IComparisonScope.class);
    }

    public static class CDODiffEngine
    extends DefaultDiffEngine {
        public CDODiffEngine() {
        }

        public CDODiffEngine(IDiffProcessor processor) {
            super(processor);
        }

        protected FeatureFilter createFeatureFilter() {
            return new CDOFeatureFilter();
        }
    }

    public static class CDOFeatureFilter
    extends FeatureFilter {
        protected boolean isIgnoredAttribute(EAttribute attribute) {
            return attribute == null || attribute.isDerived() || this.isTransient((EStructuralFeature)attribute);
        }

        protected boolean isTransient(EStructuralFeature feature) {
            return !EMFUtil.isPersistent((EStructuralFeature)feature);
        }
    }

    public static class CDOIDFunction
    implements Function<EObject, String> {
        public String apply(EObject o) {
            CDOObject object = CDOUtil.getCDOObject((EObject)o);
            CDOID id = object.cdoID();
            StringBuilder builder = new StringBuilder();
            CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
            return builder.toString();
        }
    }

    public static class CDOMatchEngine
    extends DefaultMatchEngine {
        CDOMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
            super(matcher, comparisonFactory);
        }

        protected void match(Comparison comparison, IComparisonScope scope, Notifier left, Notifier right, Notifier origin, Monitor monitor) {
            this.match(comparison, scope, (EObject)left, (EObject)right, (EObject)origin, monitor);
        }

        public static class Factory
        implements IMatchEngine.Factory {
            private final IMatchEngine matchEngine;
            private int ranking;

            public Factory(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
                this.matchEngine = this.createMatchEngine(matcher, comparisonFactory);
            }

            protected Factory(IMatchEngine matchEngine) {
                this.matchEngine = matchEngine;
            }

            protected CDOMatchEngine createMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
                return new CDOMatchEngine(matcher, comparisonFactory);
            }

            public IMatchEngine getMatchEngine() {
                return this.matchEngine;
            }

            public int getRanking() {
                return this.ranking;
            }

            public void setRanking(int ranking) {
                this.ranking = ranking;
            }

            public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
                return scope instanceof CDOComparisonScope;
            }
        }
    }

    public static class CDOMatcher
    extends IdentifierEObjectMatcher {
        private static final Method GETPARENTEOBJECT_METHOD;
        private final Function<EObject, String> idComputation;

        static {
            Method method = null;
            try {
                method = ReflectUtil.getMethod(IdentifierEObjectMatcher.class, (String)"getParentEObject", (Class[])new Class[]{EObject.class});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GETPARENTEOBJECT_METHOD = method;
        }

        public CDOMatcher(Function<EObject, String> idComputation) {
            super(idComputation);
            this.idComputation = idComputation;
        }

        protected EObject getParentEObject(EObject eObject) {
            return CDOElement.getParentOf((EObject)eObject);
        }

        protected Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
            if (GETPARENTEOBJECT_METHOD == null) {
                return this.matchPerIdCompatibility(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
            }
            return super.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        }

        private Set<Match> matchPerIdCompatibility(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
            Match parent;
            EObject parentEObject;
            Match match;
            String identifier;
            List<EObject> leftEObjectsNoID1 = leftEObjectsNoID;
            List<EObject> rightEObjectsNoID1 = rightEObjectsNoID;
            List<EObject> originEObjectsNoID1 = originEObjectsNoID;
            LinkedHashSet matches = Sets.newLinkedHashSet();
            HashMap idToMatch = Maps.newHashMap();
            HashMap leftEObjectsToMatch = Maps.newHashMap();
            HashMap rightEObjectsToMatch = Maps.newHashMap();
            HashMap originEObjectsToMatch = Maps.newHashMap();
            while (leftEObjects.hasNext()) {
                EObject left = leftEObjects.next();
                identifier = (String)this.idComputation.apply((Object)left);
                if (identifier != null) {
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(left);
                    parentEObject = this.getParentEObject(left);
                    parent = (Match)leftEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        matches.add(match);
                    }
                    idToMatch.put(identifier, match);
                    leftEObjectsToMatch.put(left, match);
                    continue;
                }
                leftEObjectsNoID1.add(left);
            }
            while (rightEObjects.hasNext()) {
                EObject right = rightEObjects.next();
                identifier = (String)this.idComputation.apply((Object)right);
                if (identifier != null) {
                    match = (Match)idToMatch.get(identifier);
                    if (match != null) {
                        match.setRight(right);
                        rightEObjectsToMatch.put(right, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(right);
                    parentEObject = this.getParentEObject(right);
                    parent = (Match)rightEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        matches.add(match);
                    }
                    rightEObjectsToMatch.put(right, match);
                    idToMatch.put(identifier, match);
                    continue;
                }
                rightEObjectsNoID1.add(right);
            }
            while (originEObjects.hasNext()) {
                EObject origin = originEObjects.next();
                identifier = (String)this.idComputation.apply((Object)origin);
                if (identifier != null) {
                    match = (Match)idToMatch.get(identifier);
                    if (match != null) {
                        match.setOrigin(origin);
                        originEObjectsToMatch.put(origin, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(origin);
                    parentEObject = this.getParentEObject(origin);
                    parent = (Match)originEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        matches.add(match);
                    }
                    idToMatch.put(identifier, match);
                    originEObjectsToMatch.put(origin, match);
                    continue;
                }
                originEObjectsNoID1.add(origin);
            }
            return matches;
        }
    }
}

