/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenSessionDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.widgets.SessionComposite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.NotAuthenticatedException;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public final class OpenSessionAction
extends LongRunningAction {
    private static final String TITLE = OpenSessionDialog.TITLE;
    private static final String TOOL_TIP = Messages.getString("OpenSessionAction.0");
    private SessionComposite sessionComposite;

    public OpenSessionAction(IWorkbenchPage page) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, CDOSessionsView.getAddImageDescriptor());
    }

    protected void preRun() throws Exception {
        OpenSessionDialog dialog = new OpenSessionDialog(this.getPage());
        if (dialog.open() == 0) {
            this.sessionComposite = dialog.getSessionComposite();
            this.sessionComposite.rememberSettings();
        } else {
            this.cancel();
        }
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        try {
            IManagedContainer container = this.getContainer();
            String productGroup = "org.eclipse.emf.cdo.sessions";
            String description = this.sessionComposite.getSessionDescription();
            String userID = (String)org.eclipse.emf.internal.cdo.bundle.OM.PREF_USER_NAME.getValue();
            if (userID != null) {
                description = String.valueOf(description) + "&userID=" + userID;
            }
            CDOSession session = (CDOSession)container.getElement(productGroup, "cdo", description);
            if (this.sessionComposite.isAutomaticRegistry()) {
                CDOPackageRegistryPopulator.populate((CDOPackageRegistry)session.getPackageRegistry());
            }
        }
        catch (RemoteException ex) {
            Throwable cause = ex.getCause();
            this.handleError(cause);
        }
        catch (Exception ex) {
            this.handleError(ex);
        }
    }

    protected void handleError(Throwable ex) {
        if (!(ex instanceof NotAuthenticatedException)) {
            this.showError(ex);
        }
    }

    protected void showError(final Throwable ex) {
        OM.LOG.error(ex);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)OpenSessionAction.this.getShell(), (String)OpenSessionAction.this.getText(), (String)(String.valueOf(Messages.getString("OpenSessionAction.3")) + ex.getMessage()));
            }
        });
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

