/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.edit.CDOEditPlugin;
import org.eclipse.emf.cdo.expressions.provider.ExpressionsEditPlugin;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;

public final class SecurityEditPlugin
extends EMFPlugin {
    public static final SecurityEditPlugin INSTANCE = new SecurityEditPlugin();
    private static Implementation plugin;

    public SecurityEditPlugin() {
        super(new ResourceLocator[]{EcoreEditPlugin.INSTANCE, CDOEditPlugin.INSTANCE, ExpressionsEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static List<EPackage> getSortedPackages(CDOView view) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        CDOPackageInfo[] cDOPackageInfoArray = view.getSession().getPackageRegistry().getPackageInfos();
        int n = cDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
            result.add(packageInfo.getEPackage());
            ++n2;
        }
        Collections.sort(result, new Comparator<EPackage>(){

            @Override
            public int compare(EPackage p1, EPackage p2) {
                return p1.getNsURI().compareTo(p2.getNsURI());
            }
        });
        return result;
    }

    public static List<EClass> getSortedClasses(CDOView view) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        CDOPackageInfo[] cDOPackageInfoArray = view.getSession().getPackageRegistry().getPackageInfos();
        int n = cDOPackageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOPackageInfo packageInfo = cDOPackageInfoArray[n2];
            for (EClassifier classifier : packageInfo.getEPackage().getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                result.add((EClass)classifier);
            }
            ++n2;
        }
        Collections.sort(result, new Comparator<EClass>(){

            @Override
            public int compare(EClass c1, EClass c2) {
                int comparison = c1.getName().compareTo(c2.getName());
                if (comparison == 0) {
                    comparison = c1.getEPackage().getNsURI().compareTo(c2.getEPackage().getNsURI());
                }
                return comparison;
            }
        });
        return result;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }
}

