/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ObservableColumnLabelProvider<M>
extends CellLabelProvider {
    private IObservableMap<M, ?>[] attributeMaps;
    private IMapChangeListener<M, Object> mapChangeListener = event -> {
        Set affectedElements = event.diff.getChangedKeys();
        LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, affectedElements.toArray());
        this.fireLabelProviderChanged(newEvent);
    };

    public ObservableColumnLabelProvider(IObservableMap<?, ?> attributeMap) {
        this(new IObservableMap[]{attributeMap});
    }

    protected ObservableColumnLabelProvider(IObservableMap<M, ?>[] attributeMaps) {
        this.attributeMaps = new IObservableMap[attributeMaps.length];
        System.arraycopy(attributeMaps, 0, this.attributeMaps, 0, attributeMaps.length);
        int i = 0;
        while (i < attributeMaps.length) {
            attributeMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.attributeMaps.length) {
            this.attributeMaps[i].removeMapChangeListener(this.mapChangeListener);
            ++i;
        }
        super.dispose();
        this.attributeMaps = null;
        this.mapChangeListener = null;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        cell.setImage(this.getImage(element));
        cell.setBackground(this.getBackground(element));
        cell.setForeground(this.getForeground(element));
        cell.setFont(this.getFont(element));
    }

    public String getText(M element) {
        Object value = this.attributeMaps[0].get(element);
        return value == null ? "" : value.toString();
    }

    public Font getFont(M element) {
        return null;
    }

    public Color getBackground(M element) {
        return null;
    }

    public Color getForeground(M element) {
        return null;
    }

    public Image getImage(M element) {
        return null;
    }
}

