/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.ChangeCredentialsRequest;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.DiffieHellman;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdateProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public class CredentialsChallengeIndication
extends IndicationWithMonitoring {
    private AtomicReference<char[]> newPasswordReceiver = (AtomicReference)ChangeCredentialsRequest.NEW_PASSWORD_RECEIVERS.remove(this.getSession());
    private DiffieHellman.Server.Challenge challenge;
    private CredentialsUpdateOperation operation;
    private String userID;

    public CredentialsChallengeIndication(SignalProtocol<?> protocol) {
        super(protocol, (short)57);
    }

    public CDOClientProtocol getProtocol() {
        return (CDOClientProtocol)super.getProtocol();
    }

    protected InternalCDOSession getSession() {
        return (InternalCDOSession)this.getProtocol().getSession();
    }

    protected int getIndicatingWorkPercent() {
        return 1;
    }

    protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.operation = (CredentialsUpdateOperation)in.readEnum(CredentialsUpdateOperation.class);
        this.userID = in.readString();
        this.challenge = new DiffieHellman.Server.Challenge((ExtendedDataInput)in);
    }

    protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            IPasswordCredentialsProvider credentialsProvider = this.getSession().getCredentialsProvider();
            if (!(credentialsProvider instanceof IPasswordCredentialsUpdateProvider)) {
                throw new IllegalStateException("No credentials update provider configured");
            }
            IPasswordCredentialsUpdate credentials = ((IPasswordCredentialsUpdateProvider)credentialsProvider).getCredentialsUpdate(this.userID, this.operation);
            if (credentials == null) {
                out.writeBoolean(false);
                return;
            }
            try {
                String authUserID = credentials.getUserID();
                String authPassword = SecurityUtil.toString((char[])credentials.getPassword());
                String newPassword = SecurityUtil.toString((char[])credentials.getNewPassword());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ExtendedDataOutputStream stream = new ExtendedDataOutputStream((OutputStream)baos);
                switch (this.operation) {
                    case CHANGE_PASSWORD: {
                        stream.writeString(authUserID);
                        stream.writeString(authPassword);
                        stream.writeString(newPassword);
                        if (this.newPasswordReceiver == null) break;
                        this.newPasswordReceiver.set(credentials.getNewPassword());
                        this.newPasswordReceiver = null;
                        break;
                    }
                    case RESET_PASSWORD: {
                        stream.writeString(authUserID);
                        stream.writeString(authPassword);
                        stream.writeString(this.userID);
                        stream.writeString(newPassword);
                    }
                }
                stream.close();
                byte[] clearText = baos.toByteArray();
                DiffieHellman.Client client = new DiffieHellman.Client();
                DiffieHellman.Client.Response response = client.handleChallenge(this.challenge, clearText);
                out.writeBoolean(true);
                response.write((ExtendedDataOutput)out);
            }
            catch (Throwable ex) {
                out.writeBoolean(false);
                OM.LOG.error(ex);
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

