/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.ILogicalModelViewHandler;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelViewHandlerUtil;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractLogicalModelViewHandler
implements ILogicalModelViewHandler {
    @Override
    public boolean canHandle(IWorkbenchPart part, ISelection selection) {
        Collection<IFile> files = this.getFiles(part, selection);
        for (IFile file : files) {
            if (!LogicalModelViewHandlerUtil.isEMFCompareCompliantFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IFile> getFiles(IWorkbenchPart part, ISelection selection) {
        return Collections.emptySet();
    }

    @Override
    public Collection<SynchronizationModel> getSynchronizationModels(IWorkbenchPart part, ISelection selection, IProgressMonitor monitor) {
        LinkedHashSet models = Sets.newLinkedHashSet();
        Collection<IFile> files = this.getFiles(part, selection);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100).setWorkRemaining(files.size());
        for (IFile file : files) {
            models.addAll(LogicalModelViewHandlerUtil.getSynchronizationModels(file, (IProgressMonitor)subMonitor.newChild(1)));
        }
        return models;
    }
}

