/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.util;

import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.architecture.ADElement;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;

public final class FormattableADElement
implements Formattable {
    private static final String ELLIPSIS = "...";
    private final ADElement element;

    public FormattableADElement(ADElement element) {
        this.element = element;
    }

    public static Object wrap(Object formatArgument) {
        return FormattableADElement.canWrap(formatArgument) ? FormattableADElement.doWrap(formatArgument) : formatArgument;
    }

    private static Object doWrap(Object formatArgument) {
        Object[] result;
        if (formatArgument instanceof ADElement) {
            result = new FormattableADElement((ADElement)formatArgument);
        } else if (formatArgument instanceof Iterable) {
            Object[] resultList = new ArrayList();
            for (Object next : (Iterable)formatArgument) {
                resultList.add(FormattableADElement.wrap(next));
            }
            result = resultList;
        } else if (formatArgument instanceof Object[]) {
            Object[] resultArray = (Object[])((Object[])formatArgument).clone();
            int i = 0;
            while (i < resultArray.length) {
                resultArray[i] = FormattableADElement.wrap(resultArray[i]);
                ++i;
            }
            result = resultArray;
        } else {
            result = formatArgument;
        }
        return result;
    }

    public static Object[] wrapAll(Object ... formatArguments) {
        Object[] result = formatArguments;
        int i = 0;
        while (i < formatArguments.length) {
            if (FormattableADElement.canWrap(formatArguments[i])) {
                result = FormattableADElement.doWrapAll(formatArguments);
                break;
            }
            ++i;
        }
        return result;
    }

    private static boolean canWrap(Object formatArgument) {
        return formatArgument instanceof ADElement || formatArgument instanceof Iterable && FormattableADElement.canWrapAny((Iterable)formatArgument) || formatArgument instanceof Object[] && FormattableADElement.canWrapAny((Object[])formatArgument);
    }

    private static boolean canWrapAny(Object[] formatArgument) {
        boolean result = false;
        int i = 0;
        while (!result && i < formatArgument.length) {
            result = FormattableADElement.canWrap(formatArgument[i]);
            ++i;
        }
        return result;
    }

    private static boolean canWrapAny(Iterable<?> formatArgument) {
        boolean result = false;
        Iterator<?> iter = formatArgument.iterator();
        while (!result && iter.hasNext()) {
            result = FormattableADElement.canWrap(iter.next());
        }
        return result;
    }

    private static Object[] doWrapAll(Object ... formatArguments) {
        Object[] result = new Object[formatArguments.length];
        int i = 0;
        while (i < formatArguments.length) {
            result[i] = FormattableADElement.wrap(formatArguments[i]);
            ++i;
        }
        return result;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        StringBuilder buf = new StringBuilder();
        String name = String.valueOf((flags & 4) == 4 ? this.element.getId() : this.name());
        if ((flags & 2) == 2) {
            name = name.toUpperCase(formatter.locale());
        }
        String eclass = this.eclass();
        String resource = String.valueOf(this.resourceURI());
        int nameLen = name.length();
        int eclassLen = eclass.length() + 3;
        int resourceLen = resource.length() + 3;
        if (precision < 0 || precision >= nameLen + eclassLen + resourceLen) {
            buf.append('<').append(eclass).append("> ");
            buf.append(name);
            buf.append(" (").append(resource).append(')');
        } else {
            int trunc;
            int totalLen;
            int ellipsis = ELLIPSIS.length();
            int ellipsis2 = 2 * ellipsis;
            if (precision <= nameLen) {
                if (nameLen > ellipsis2) {
                    buf.append(ELLIPSIS).append(name.substring(nameLen - precision + ellipsis));
                } else {
                    buf.append(name.substring(nameLen - precision));
                }
            } else if (precision <= eclassLen + nameLen) {
                totalLen = eclassLen + nameLen;
                trunc = totalLen - precision;
                int howMuchName = nameLen - trunc;
                if (howMuchName < ellipsis2) {
                    howMuchName = Math.min(nameLen, precision);
                    if (howMuchName < nameLen) {
                        if (howMuchName > ellipsis2) {
                            buf.append(ELLIPSIS).append(name.substring(nameLen - howMuchName + ellipsis));
                        } else {
                            buf.append(name.substring(nameLen - howMuchName));
                        }
                    }
                } else {
                    buf.append('<').append(eclass).append("> ");
                    buf.append(ELLIPSIS);
                    buf.append(name.substring(nameLen - howMuchName + ellipsis));
                }
            } else {
                buf.append('<').append(eclass).append("> ");
                buf.append(name);
                totalLen = eclassLen + nameLen + resourceLen;
                trunc = totalLen - precision;
                int ellipsis3 = ellipsis2 + ellipsis;
                int howMuchResource = resourceLen - trunc;
                if (howMuchResource >= ellipsis3) {
                    buf.append(" (").append(ELLIPSIS);
                    buf.append(resource.substring(resourceLen - howMuchResource + ellipsis));
                    buf.append(')');
                }
            }
        }
        int totalLen = buf.length();
        if (totalLen < width) {
            int i = 0;
            while (i < width - totalLen) {
                if ((flags & 1) == 1) {
                    buf.append(' ');
                } else {
                    buf.insert(0, ' ');
                }
                ++i;
            }
        }
        formatter.format(buf.toString(), new Object[0]);
    }

    public String toString() {
        String resource = this.resourceURI();
        return String.format(resource == null ? "<%s> %s" : "<%s> %s (%s)", this.eclass(), this.name(), resource);
    }

    private String eclass() {
        EClass eclass = this.element.eClass();
        if (eclass.getEPackage() == ArchitecturePackage.eINSTANCE) {
            switch (eclass.getClassifierID()) {
                case 1: {
                    return "Domain";
                }
                case 8: {
                    return "Framework";
                }
                case 2: {
                    return "ADL";
                }
                case 5: {
                    return "Viewpoint";
                }
            }
        }
        return eclass.getName();
    }

    private String name() {
        String result = this.element.getQualifiedName();
        if (result == null) {
            result = this.element.getName();
        }
        return result;
    }

    private String resourceURI() {
        URI result;
        Resource resource = this.element.eResource();
        URI uRI = result = resource == null ? null : resource.getURI();
        if (result != null) {
            result = result.trimFileExtension();
        }
        return result == null ? null : result.toString();
    }
}

