/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.handlers;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchCreationContext;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.dialogs.CreateBranchDialog;
import org.eclipse.emf.cdo.ui.AbstractAuthorizingHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateBranchHandler
extends AbstractAuthorizingHandler<CDOBranchCreationContext> {
    private CDOBranchPoint base;
    private String name;

    public CreateBranchHandler() {
        super(CDOBranchCreationContext.class, "org.eclipse.emf.cdo.ui.CreateBranches");
    }

    protected void preRun(ExecutionEvent event) throws Exception {
        if (this.elements.size() == 1) {
            CDOBranchCreationContext context = (CDOBranchCreationContext)this.elements.get(0);
            this.base = context.getBase();
            this.name = CreateBranchHandler.getValidChildName(this.base.getBranch());
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            CreateBranchDialog dialog = new CreateBranchDialog(shell, this.base, this.name);
            if (dialog.open() == 0) {
                this.base = dialog.getBranchPoint();
                this.name = dialog.getName();
                return;
            }
        }
        this.base = null;
        this.name = null;
        this.cancel();
    }

    protected void doExecute(IProgressMonitor monitor) throws Exception {
        try {
            CDOBranch branch = this.base.getBranch();
            branch.createBranch(this.name, this.base.getTimeStamp());
        }
        finally {
            this.base = null;
            this.name = null;
        }
    }

    protected String getErrorMessage(Exception ex) {
        return "Branch " + this.name + " could not be created.";
    }

    public static String getValidChildName(CDOBranch branch) {
        HashSet<String> names = new HashSet<String>();
        CDOBranch[] cDOBranchArray = branch.getBranches();
        int n = cDOBranchArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranch child = cDOBranchArray[n2];
            names.add(child.getName());
            ++n2;
        }
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String name = "branch" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        throw new IllegalStateException("Too many sub branches: " + branch);
    }
}

