/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugElement;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;

public class JavaDebugStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "java/debug";
    private final JavaStructureBridge javaStructureBridge = new JavaStructureBridge();
    private final Map<JDIStackFrame, IType> stackFrameMap = new WeakHashMap<JDIStackFrame, IType>();

    public boolean acceptsObject(Object object) {
        return object instanceof ILaunch || object instanceof JDIDebugElement || object instanceof RuntimeProcess;
    }

    public boolean canBeLandmark(String handle) {
        return false;
    }

    public boolean canFilter(Object element) {
        if (element instanceof JDIStackFrame) {
            JDIStackFrame stackFrame = (JDIStackFrame)element;
            try {
                IStackFrame[] frames = stackFrame.getThread().getStackFrames();
                int indexOfInterestingFrame = 0;
                int indexOfCurrentFrame = 0;
                int i = 0;
                while (i < frames.length) {
                    IInteractionElement correspondingElement;
                    IStackFrame frame = frames[i];
                    if (stackFrame.getName().equals(frame.getName())) {
                        indexOfCurrentFrame = i;
                    }
                    if ((correspondingElement = ContextCore.getContextManager().getElement(this.getHandleIdentifier(frame))) != null && correspondingElement.getInterest().isInteresting()) {
                        indexOfInterestingFrame = i;
                    }
                    ++i;
                }
                return indexOfCurrentFrame > indexOfInterestingFrame;
            }
            catch (DebugException e) {
                return false;
            }
        }
        return element instanceof JDIStackFrame;
    }

    public List<String> getChildHandles(String handle) {
        return null;
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public String getHandleForOffsetInObject(Object resource, int offset) {
        return null;
    }

    public String getHandleIdentifier(Object object) {
        if (object instanceof JDIStackFrame) {
            JDIStackFrame stackFrame = (JDIStackFrame)object;
            IType type = null;
            if (this.stackFrameMap.containsKey(stackFrame)) {
                type = this.stackFrameMap.get(stackFrame);
            } else {
                try {
                    type = JavaDebugUtils.resolveDeclaringType((IJavaStackFrame)stackFrame);
                    this.stackFrameMap.put(stackFrame, type);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            if (type != null && type.exists()) {
                return this.javaStructureBridge.getHandleIdentifier(type);
            }
        }
        return null;
    }

    public String getLabel(Object object) {
        return "" + object;
    }

    public Object getObjectForHandle(String handle) {
        return this.javaStructureBridge.getObjectForHandle(handle);
    }

    public String getParentHandle(String handle) {
        return null;
    }

    public boolean isDocument(String handle) {
        return false;
    }
}

