/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.actions.AbstractBranchPointActionProvider;
import org.eclipse.emf.cdo.transaction.CDOTransactionOpener;
import org.eclipse.emf.cdo.ui.Support;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.view.CDOViewOpener;

public class MergeFromActionProvider
extends AbstractBranchPointActionProvider {
    private static final String ID = "org.eclipse.emf.cdo.explorer.ui.checkouts.MergeFromActions";

    public MergeFromActionProvider() {
        super(ID, "Merge From");
    }

    @Override
    protected boolean createSubMenu(CDOCheckout checkout) {
        return super.createSubMenu(checkout) && !checkout.isReadOnly();
    }

    @Override
    protected String getHistorizedBranchPointToolTip(boolean allowTimeStamp) {
        return allowTimeStamp ? "Merge from this branch point" : "Merge from this branch";
    }

    @Override
    protected String getOtherBranchPointToolTip(boolean allowTimeStamp) {
        return allowTimeStamp ? "Select a branch point and merge from it" : "Select a branch and merge from it";
    }

    @Override
    protected String getCommitBranchPointToolTip() {
        return "Select a commit and merge from it";
    }

    @Override
    protected String getOtherCheckoutToolTip() {
        return "Merge from the branch point of this checkout";
    }

    @Override
    protected void execute(CDOCheckout checkout, CDOBranchPoint branchPoint) throws Exception {
        MergeFromActionProvider.mergeFrom(checkout, branchPoint);
    }

    public static void mergeFrom(CDOCheckout checkout, CDOBranchPoint branchPoint) {
        if (Support.COMPARE.isAvailable()) {
            CDORepository repository = checkout.getRepository();
            CDOBranchPoint left = branchPoint;
            CDOBranchPoint right = checkout.getBranchPoint();
            CDOCompareEditorUtil.TransactionOpenerAndEditorCloser transactionOpener = new CDOCompareEditorUtil.TransactionOpenerAndEditorCloser((CDOTransactionOpener)repository, true);
            CDOCompareEditorUtil.openEditor((CDOViewOpener)repository, (CDOTransactionOpener)transactionOpener, (CDOBranchPoint)left, (CDOBranchPoint)right, null, (boolean)true);
        }
    }
}

