/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.common.util.CDOQueryQueue;
import org.eclipse.emf.cdo.internal.server.QueryResult;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryContext;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ThreadPool;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryManager
extends Lifecycle
implements InternalQueryManager {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SESSION, QueryManager.class);
    private InternalRepository repository;
    private Map<Integer, QueryContext> queryContexts = new ConcurrentHashMap<Integer, QueryContext>();
    private ExecutorService executors;
    private boolean shutdownExecutorService;
    private int nextQuery;
    private boolean allowInterruptRunningQueries = true;

    @Override
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(InternalRepository repository) {
        this.repository = repository;
        String value = repository.getProperties().get("allowInterruptRunningQueries");
        if (value != null) {
            this.allowInterruptRunningQueries = Boolean.parseBoolean(value);
        }
    }

    public synchronized ExecutorService getExecutors() {
        if (this.executors == null) {
            this.executors = ConcurrencyUtil.getExecutorService((Object)this.repository);
            if (this.executors == null) {
                this.shutdownExecutorService = true;
                this.executors = ThreadPool.create();
            }
        }
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService executors) {
        if (this.shutdownExecutorService) {
            if (this.executors != null) {
                this.executors.shutdown();
            }
            this.shutdownExecutorService = false;
        }
        this.executors = executors;
    }

    @Override
    public InternalQueryResult execute(InternalView view, CDOQueryInfo queryInfo) {
        QueryResult queryResult = new QueryResult(view, queryInfo, this.getNextQueryID());
        QueryContext queryContext = new QueryContext(queryResult);
        this.execute(queryContext);
        return queryResult;
    }

    @Override
    public boolean isRunning(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        return queryContext != null;
    }

    @Override
    public void cancel(int queryID) {
        QueryContext queryContext = this.queryContexts.get(queryID);
        if (queryContext == null || queryContext.getFuture().isDone()) {
            throw new RuntimeException("Query " + queryID + " is not running anymore");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Cancelling query for context: " + queryContext);
        }
        queryContext.cancel();
    }

    public synchronized void register(QueryContext queryContext) {
        int queryID = queryContext.getQueryResult().getQueryID();
        this.queryContexts.put(queryID, queryContext);
        queryContext.addListener();
    }

    public synchronized void unregister(QueryContext queryContext) {
        int queryID = queryContext.getQueryResult().getQueryID();
        this.queryContexts.remove(queryID);
        queryContext.removeListener();
    }

    public synchronized int getNextQueryID() {
        return ++this.nextQuery;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.setExecutors(null);
    }

    private Future<?> execute(QueryContext queryContext) {
        this.register(queryContext);
        InternalSession session = queryContext.getView().getSession();
        ExecutorService executors = this.getExecutors();
        Future<?> future = executors.submit(StoreThreadLocal.wrap((ISession)session, queryContext));
        queryContext.setFuture(future);
        return future;
    }

    private final class QueryContext
    implements IQueryContext,
    Runnable {
        private final IListener sessionListener = new IListener(){

            public void notifyEvent(IEvent event) {
                if (event instanceof SingleDeltaContainerEvent) {
                    InternalView view = QueryContext.this.getQueryResult().getView();
                    SingleDeltaContainerEvent deltaEvent = (SingleDeltaContainerEvent)event;
                    if (deltaEvent.getDeltaKind() == IContainerDelta.Kind.REMOVED && deltaEvent.getDeltaElement() == view) {
                        QueryContext.this.cancel();
                    }
                }
            }
        };
        private CDOBranchPoint branchPoint;
        private InternalQueryResult queryResult;
        private boolean started;
        private volatile boolean cancelled;
        private int resultCount;
        private Future<?> future;

        public QueryContext(InternalQueryResult queryResult) {
            this.queryResult = queryResult;
            InternalView view = this.getView();
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        }

        public InternalQueryResult getQueryResult() {
            return this.queryResult;
        }

        @Override
        public InternalView getView() {
            return this.queryResult.getView();
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        public Future<?> getFuture() {
            return this.future;
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.future != null) {
                    this.future.cancel(QueryManager.this.allowInterruptRunningQueries);
                }
                if (!this.started) {
                    QueryManager.this.unregister(this);
                }
            }
        }

        @Override
        public int getResultCount() {
            return this.resultCount;
        }

        @Override
        public boolean addResult(Object object) {
            if (this.resultCount == 0) {
                throw new IllegalStateException("Maximum number of results exceeded");
            }
            CDOQueryQueue<Object> queue = this.queryResult.getQueue();
            queue.add(object);
            return !this.cancelled && --this.resultCount > 0;
        }

        @Override
        public void run() {
            CDOQueryQueue<Object> queue = this.queryResult.getQueue();
            try {
                this.started = true;
                CDOQueryInfo info = this.queryResult.getQueryInfo();
                this.resultCount = info.getMaxResults() < 0 ? Integer.MAX_VALUE : info.getMaxResults();
                IQueryHandler handler = QueryManager.this.repository.getQueryHandler(info);
                try {
                    handler.executeQuery(info, this);
                }
                catch (Throwable executionException) {
                    this.addResult(executionException);
                    queue.close();
                    QueryManager.this.unregister(this);
                    return;
                }
            }
            catch (Throwable initializationException) {
                queue.setException(initializationException);
            }
            finally {
                queue.close();
                QueryManager.this.unregister(this);
            }
        }

        public void addListener() {
            InternalSession session = this.getQueryResult().getView().getSession();
            session.addListener(this.sessionListener);
        }

        public void removeListener() {
            InternalSession session = this.getQueryResult().getView().getSession();
            session.removeListener(this.sessionListener);
        }
    }
}

