/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.iproduct.ICSSInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.product.ProductEditor;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileExtensionsFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.pde.internal.ui.wizards.product.SynchronizationOperation;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IProgressService;

public class CSSSection
extends PDESection {
    private FormEntry fFileEntry;

    public CSSSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.CSSSection_title);
        section.setDescription(PDEUIMessages.CSSSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        client.setLayoutData((Object)new TableWrapData(256));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        Composite child = toolkit.createComposite(client);
        child.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        child.setLayoutData((Object)new TableWrapData(256));
        this.fFileEntry = new FormEntry(child, toolkit, PDEUIMessages.CSSSection_file, PDEUIMessages.CSSSection_browse, false);
        BidiUtils.applyBidiProcessing((Text)this.fFileEntry.getText(), (String)"file");
        this.fFileEntry.setEditable(this.isEditable());
        this.fFileEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                CSSSection.this.getCSSInfo().setFilePath(entry.getValue());
            }

            @Override
            public void browseButtonSelected(FormEntry entry) {
                CSSSection.this.handleBrowse();
            }
        });
        FormText text = toolkit.createFormText(client, true);
        text.setText(PDEUIMessages.CSSSection_synchronize, true, true);
        data = new TableWrapData(256);
        text.setLayoutData((Object)data);
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                IStatusLineManager mng = CSSSection.this.getPage().getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mng.setMessage(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                IStatusLineManager mng = CSSSection.this.getPage().getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mng.setMessage(null);
            }

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                if (href.equals("command.synchronize")) {
                    CSSSection.this.handleSynchronize();
                }
            }
        });
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void handleBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.CSSSection_fileTitle);
        dialog.setMessage(PDEUIMessages.CSSSection_fileMessage);
        FileExtensionsFilter filter = new FileExtensionsFilter();
        filter.addFileExtension("css");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            this.fFileEntry.setValue(file.getFullPath().toString());
        }
    }

    void handleSynchronize() {
        ProductEditor editor = (ProductEditor)this.getPage().getEditor();
        try {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            IPluginModelBase model = PluginRegistry.findModel((String)this.getProduct().getDefiningPluginId());
            if (model == null) {
                MessageDialog.openError((Shell)this.getSection().getShell(), (String)PDEUIMessages.CSSSection_errorNoDefiningPluginTitle, (String)PDEUIMessages.CSSSection_errorNoDefiningPlugin);
                return;
            }
            IProject project = model.getUnderlyingResource().getProject();
            IFile buildProps = PDEProject.getBuildProperties((IProject)project);
            if (buildProps.exists()) {
                WorkspaceBuildModel wkspc = new WorkspaceBuildModel(buildProps);
                wkspc.load();
                if (wkspc.isLoaded()) {
                    Path pth;
                    String path;
                    IBuildEntry entry = wkspc.getBuild().getEntry("bin.includes");
                    if (entry == null) {
                        entry = wkspc.getFactory().createEntry("bin.includes");
                        wkspc.getBuild().add(entry);
                    }
                    if (!entry.contains(path = (pth = new Path(this.getCSSInfo().getFilePath())).removeFirstSegments(1).toString())) {
                        entry.addToken(path);
                    }
                    wkspc.save();
                }
            }
            SynchronizationOperation op = new SynchronizationOperation(this.getProduct(), editor.getSite().getShell(), project);
            service.runInUI((IRunnableContext)service, (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Synchronize", (String)e.getTargetException().getMessage());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e, "Synchronize", null);
        }
    }

    public void refresh() {
        this.fFileEntry.setValue(this.getCSSInfo().getFilePath(), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fFileEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fFileEntry.cancelEdit();
        super.cancelEdit();
    }

    private ICSSInfo getCSSInfo() {
        ICSSInfo info = this.getProduct().getCSSInfo();
        if (info == null) {
            info = this.getModel().getFactory().createCSSInfo();
            this.getProduct().setCSSInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

