/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.commands.AbstractMarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.commands.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.ComboTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.ui.IMarketplaceClientConfiguration;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class MarketplaceWizardCommand
extends AbstractMarketplaceWizardCommand
implements IHandler {
    private static final String TRIGGER_PARAMETER = "trigger";
    private String wizardState;
    private Map<String, org.eclipse.epp.mpc.ui.Operation> operations;
    private MarketplaceWizard.WizardState wizardDialogState;

    @Override
    protected MarketplaceCatalogConfiguration createConfiguration(final MarketplaceCatalog catalog, ExecutionEvent event) {
        MarketplaceCatalogConfiguration configuration = super.createConfiguration(catalog, event);
        if (configuration == null) {
            return null;
        }
        configuration.getFilters().clear();
        final ComboTagFilter marketFilter = new ComboTagFilter(){

            @Override
            public void catalogUpdated(boolean wasCancelled) {
                ArrayList<Tag> choices = new ArrayList<Tag>();
                List<IMarket> markets = catalog.getMarkets();
                for (IMarket market : markets) {
                    Tag marketTag = new Tag(IMarket.class, market.getId(), market.getName());
                    marketTag.setData((Object)market);
                    choices.add(marketTag);
                }
                this.setChoices(choices);
            }
        };
        marketFilter.setSelectAllOnNoSelection(true);
        marketFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allMarkets);
        marketFilter.setTagClassification(ICategory.class);
        marketFilter.setChoices(new ArrayList<Tag>());
        ComboTagFilter marketCategoryTagFilter = new ComboTagFilter(){

            @Override
            public void catalogUpdated(boolean wasCancelled) {
                MarketplaceWizardCommand.this.updateCategoryChoices(this, marketFilter);
            }
        };
        marketCategoryTagFilter.setSelectAllOnNoSelection(true);
        marketCategoryTagFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allCategories);
        marketCategoryTagFilter.setTagClassification(ICategory.class);
        marketCategoryTagFilter.setChoices(new ArrayList<Tag>());
        IPropertyChangeListener marketListener = event1 -> {
            String property = event1.getProperty();
            if ("selected".equals(property)) {
                this.updateCategoryChoices(marketCategoryTagFilter, marketFilter);
            }
        };
        marketFilter.addPropertyChangeListener(marketListener);
        configuration.getFilters().add(marketFilter);
        configuration.getFilters().add(marketCategoryTagFilter);
        configuration.setInitialState(this.wizardState);
        if (this.operations != null && !this.operations.isEmpty()) {
            configuration.setInitialOperations(this.operations);
        }
        for (CatalogFilter filter : configuration.getFilters()) {
            ((MarketplaceFilter)filter).setCatalog(catalog);
        }
        return configuration;
    }

    @Override
    protected MarketplaceWizardDialog createWizardDialog(DiscoveryWizard wizard, ExecutionEvent event) {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (activeShell == null) {
            activeShell = WorkbenchUtil.getShell();
        }
        return new MarketplaceWizardDialog(activeShell, (MarketplaceWizard)wizard);
    }

    @Override
    protected MarketplaceWizard createWizard(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration, ExecutionEvent event) {
        MarketplaceWizard wizard = new MarketplaceWizard(catalog, configuration);
        wizard.setInitialState(this.wizardDialogState);
        wizard.setWindowTitle(Messages.MarketplaceWizardCommand_eclipseMarketplace);
        String trigger = event.getParameter(TRIGGER_PARAMETER);
        wizard.setTrigger(trigger);
        return wizard;
    }

    private void updateCategoryChoices(ComboTagFilter marketCategoryTagFilter, ComboTagFilter marketFilter) {
        HashSet<Tag> newChoices = new HashSet<Tag>();
        ArrayList<Tag> choices = new ArrayList<Tag>();
        HashSet<IMarket> selectedMarkets = new HashSet<IMarket>();
        for (Tag marketTag : marketFilter.getSelected()) {
            selectedMarkets.add((IMarket)marketTag.getData());
        }
        MarketplaceCatalog catalog = (MarketplaceCatalog)marketCategoryTagFilter.getCatalog();
        List<IMarket> markets = catalog.getMarkets();
        for (IMarket market : markets) {
            if (!selectedMarkets.isEmpty() && !selectedMarkets.contains(market)) continue;
            for (ICategory marketCategory : market.getCategory()) {
                Tag categoryTag = new Tag(ICategory.class, marketCategory.getId(), marketCategory.getName());
                categoryTag.setData((Object)marketCategory);
                if (!newChoices.add(categoryTag)) continue;
                choices.add(categoryTag);
            }
        }
        Collections.sort(choices, (o1, o2) -> o1.getLabel().compareTo(o2.getLabel()));
        marketCategoryTagFilter.setChoices(choices);
    }

    public void setWizardState(String wizardState) {
        this.wizardState = wizardState;
    }

    public void setWizardDialogState(MarketplaceWizard.WizardState wizardState) {
        this.wizardDialogState = wizardState;
    }

    @Deprecated
    public void setOperationByNodeId(Map<String, Operation> operationByNodeId) {
        this.operations = Operation.mapAllBack(operationByNodeId);
    }

    public void setOperations(Map<String, org.eclipse.epp.mpc.ui.Operation> operationByNodeId) {
        this.operations = operationByNodeId;
    }

    @Override
    public void setConfiguration(IMarketplaceClientConfiguration configuration) {
        super.setConfiguration(configuration);
        this.setOperations(configuration.getInitialOperations());
        this.setWizardState((String)configuration.getInitialState());
    }
}

