/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ecore.dependencies.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.ecore.dependencies.DependenciesPackage;
import org.eclipse.emf.cdo.ecore.dependencies.Element;
import org.eclipse.emf.cdo.ecore.dependencies.Link;
import org.eclipse.emf.cdo.ecore.dependencies.Model;
import org.eclipse.emf.cdo.ecore.dependencies.ModelContainer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ModelImpl
extends MinimalEObjectImpl.Container
implements Model,
IAdaptable {
    protected static final URI URI_EDEFAULT = null;
    protected URI uri = URI_EDEFAULT;
    protected static final IFile FILE_EDEFAULT = null;
    protected static final boolean WORKSPACE_EDEFAULT = false;
    protected static final boolean EXISTS_EDEFAULT = false;
    protected boolean exists = false;
    protected static final String NS_URI_EDEFAULT = null;
    protected String nsURI = NS_URI_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Element> elements;
    private Boolean brokenLinks;

    protected ModelImpl() {
    }

    protected EClass eStaticClass() {
        return DependenciesPackage.Literals.MODEL;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void setUri(URI newUri) {
        URI oldUri = this.uri;
        this.uri = newUri;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldUri, (Object)this.uri));
        }
    }

    @Override
    public ModelContainer getContainer() {
        if (this.eContainerFeatureID() != 1) {
            return null;
        }
        return (ModelContainer)this.eInternalContainer();
    }

    public NotificationChain basicSetContainer(ModelContainer newContainer, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newContainer, 1, msgs);
        return msgs;
    }

    @Override
    public void setContainer(ModelContainer newContainer) {
        if (newContainer != this.eInternalContainer() || this.eContainerFeatureID() != 1 && newContainer != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newContainer)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newContainer != null) {
                msgs = ((InternalEObject)newContainer).eInverseAdd((InternalEObject)this, 0, ModelContainer.class, msgs);
            }
            if ((msgs = this.basicSetContainer(newContainer, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newContainer, (Object)newContainer));
        }
    }

    @Override
    public IFile getFile() {
        URI uri = this.getUri();
        if (uri.isPlatformResource()) {
            IPath path = Path.fromPortableString((String)uri.path()).removeFirstSegments(1);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    @Override
    public boolean isWorkspace() {
        return this.getFile() != null;
    }

    @Override
    public boolean isExists() {
        return this.exists;
    }

    @Override
    public void setExists(boolean newExists) {
        boolean oldExists = this.exists;
        this.exists = newExists;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldExists, this.exists));
        }
    }

    @Override
    public String getNsURI() {
        return this.nsURI;
    }

    @Override
    public void setNsURI(String newNsURI) {
        String oldNsURI = this.nsURI;
        this.nsURI = newNsURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldNsURI, (Object)this.nsURI));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Element> getElements() {
        if (this.elements == null) {
            this.elements = new EObjectContainmentWithInverseEList(Element.class, (InternalEObject)this, 7, 1);
        }
        return this.elements;
    }

    @Override
    public EList<Link> getOutgoingLinks() {
        EObjectEList result = new EObjectEList(Link.class, (InternalEObject)this, 8);
        for (Element element : this.getElements()) {
            result.addAll(element.getOutgoingLinks());
        }
        return result;
    }

    @Override
    public EList<Link> getIncomingLinks() {
        EObjectEList result = new EObjectEList(Link.class, (InternalEObject)this, 9);
        for (Element element : this.getElements()) {
            result.addAll(element.getIncomingLinks());
        }
        return result;
    }

    @Override
    public EList<Link> getBrokenLinks() {
        EObjectEList result = new EObjectEList(Link.class, (InternalEObject)this, 5);
        for (Element element : this.getElements()) {
            result.addAll(element.getBrokenLinks());
        }
        return result;
    }

    @Override
    public EList<Model> getDependencies() {
        HashSet<Model> models = new HashSet<Model>();
        for (Element element : this.getElements()) {
            for (Link link : element.getOutgoingLinks()) {
                Element target = link.getTarget();
                if (target == null) continue;
                models.add(target.getModel());
            }
        }
        EObjectEList result = new EObjectEList(Model.class, (InternalEObject)this, 11);
        result.addAll(models);
        return result;
    }

    @Override
    public EList<Model> getDependingModels() {
        HashSet<Model> models = new HashSet<Model>();
        for (Element element : this.getElements()) {
            for (Link link : element.getIncomingLinks()) {
                models.add(link.getSource().getModel());
            }
        }
        EObjectEList result = new EObjectEList(Model.class, (InternalEObject)this, 12);
        result.addAll(models);
        return result;
    }

    @Override
    public EList<Model> getFlatDependencies() {
        return this.getFlat(DependenciesPackage.Literals.MODEL__DEPENDENCIES, 13);
    }

    @Override
    public EList<Model> getFlatDependingModels() {
        return this.getFlat(DependenciesPackage.Literals.MODEL__DEPENDING_MODELS, 14);
    }

    private EList<Model> getFlat(EReference sourceReference, int targetReferenceID) {
        HashSet<Model> set = new HashSet<Model>();
        this.fill(this, sourceReference, set);
        EObjectEList result = new EObjectEList(Model.class, (InternalEObject)this, targetReferenceID);
        result.addAll(set);
        return result;
    }

    private void fill(Model model, EReference reference, Set<Model> result) {
        EList list = (EList)model.eGet((EStructuralFeature)reference);
        for (Model element : list) {
            if (!result.add(element)) continue;
            this.fill(element, reference, result);
        }
    }

    @Override
    public boolean dependsUpon(Model target) {
        return this.dependsUpon(this, target);
    }

    private boolean dependsUpon(ModelImpl source, Model target) {
        if (source != target) {
            for (Model dependency : this.getDependencies()) {
                if (dependency != target && !((ModelImpl)dependency).dependsUpon(source, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDependency(Model target) {
        EList<Model> dependencies = this.getDependencies();
        for (Model dependency : dependencies) {
            if (dependency != target) continue;
            return;
        }
        dependencies.add((Object)target);
    }

    @Override
    public boolean hasBrokenLinks() {
        if (this.brokenLinks == null) {
            this.brokenLinks = false;
            for (Element element : this.getElements()) {
                if (!element.hasBrokenLinks()) continue;
                this.brokenLinks = true;
                break;
            }
        }
        return this.brokenLinks;
    }

    @Override
    public Element getElement(URI uri) {
        URI modelURI = uri.trimFragment();
        if (modelURI == this.getUri()) {
            for (Element element : this.getElements()) {
                if (element.getUri() != uri) continue;
                return element;
            }
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetContainer((ModelContainer)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getElements()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetContainer(null, msgs);
            }
            case 7: {
                return ((InternalEList)this.getElements()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 1: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 0, ModelContainer.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getUri();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getFile();
            }
            case 3: {
                return this.isWorkspace();
            }
            case 4: {
                return this.isExists();
            }
            case 5: {
                return this.getNsURI();
            }
            case 6: {
                return this.getName();
            }
            case 7: {
                return this.getElements();
            }
            case 8: {
                return this.getOutgoingLinks();
            }
            case 9: {
                return this.getIncomingLinks();
            }
            case 10: {
                return this.getBrokenLinks();
            }
            case 11: {
                return this.getDependencies();
            }
            case 12: {
                return this.getDependingModels();
            }
            case 13: {
                return this.getFlatDependencies();
            }
            case 14: {
                return this.getFlatDependingModels();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setUri((URI)newValue);
                return;
            }
            case 1: {
                this.setContainer((ModelContainer)newValue);
                return;
            }
            case 4: {
                this.setExists((Boolean)newValue);
                return;
            }
            case 5: {
                this.setNsURI((String)newValue);
                return;
            }
            case 6: {
                this.setName((String)newValue);
                return;
            }
            case 7: {
                this.getElements().clear();
                this.getElements().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setUri(URI_EDEFAULT);
                return;
            }
            case 1: {
                this.setContainer(null);
                return;
            }
            case 4: {
                this.setExists(false);
                return;
            }
            case 5: {
                this.setNsURI(NS_URI_EDEFAULT);
                return;
            }
            case 6: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.getElements().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return FILE_EDEFAULT == null ? this.getFile() != null : !FILE_EDEFAULT.equals((Object)this.getFile());
            }
            case 3: {
                return this.isWorkspace();
            }
            case 4: {
                return this.exists;
            }
            case 5: {
                return NS_URI_EDEFAULT == null ? this.nsURI != null : !NS_URI_EDEFAULT.equals(this.nsURI);
            }
            case 6: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 7: {
                return this.elements != null && !this.elements.isEmpty();
            }
            case 8: {
                return !this.getOutgoingLinks().isEmpty();
            }
            case 9: {
                return !this.getIncomingLinks().isEmpty();
            }
            case 10: {
                return !this.getBrokenLinks().isEmpty();
            }
            case 11: {
                return !this.getDependencies().isEmpty();
            }
            case 12: {
                return !this.getDependingModels().isEmpty();
            }
            case 13: {
                return !this.getFlatDependencies().isEmpty();
            }
            case 14: {
                return !this.getFlatDependingModels().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.dependsUpon((Model)arguments.get(0));
            }
            case 1: {
                this.addDependency((Model)arguments.get(0));
                return null;
            }
            case 2: {
                return this.hasBrokenLinks();
            }
            case 3: {
                return this.getElement((URI)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (uri: ");
        result.append(this.uri);
        result.append(", exists: ");
        result.append(this.exists);
        result.append(", nsURI: ");
        result.append(this.nsURI);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResource.class || adapter == IFile.class) {
            IFile file = this.getFile();
            return (T)file;
        }
        return null;
    }
}

