/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class UniqueLaunchConfigurationFileFilter
extends ViewerFilter {
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        int size = elements.length;
        if (size == 0) {
            return elements;
        }
        ArrayList<Object> filteredElements = new ArrayList<Object>(size);
        HashMap configPathMap = new HashMap();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)element;
                String path = this.toLaunchFileLocation(config);
                if (!configPathMap.containsKey(path)) {
                    configPathMap.put(path, new ArrayList());
                }
                ((List)configPathMap.get(path)).add(config);
            } else {
                filteredElements.add(element);
            }
            ++n2;
        }
        for (Map.Entry entry : configPathMap.entrySet()) {
            List configsWithSamePath = (List)entry.getValue();
            if (entry.getKey() == null) {
                filteredElements.addAll(configsWithSamePath);
                continue;
            }
            if (configsWithSamePath.size() == 1) {
                filteredElements.add(configsWithSamePath.get(0));
                continue;
            }
            if (configsWithSamePath.size() <= 1) continue;
            configsWithSamePath.sort((o1, o2) -> {
                IPath path1 = o1.getFile().getProjectRelativePath();
                IPath path2 = o2.getFile().getProjectRelativePath();
                return Integer.compare(path1.segmentCount(), path2.segmentCount());
            });
            filteredElements.add(configsWithSamePath.get(0));
        }
        return filteredElements.toArray();
    }

    private String toLaunchFileLocation(ILaunchConfiguration config) {
        IPath path;
        IFile file;
        if (!config.isLocal() && (file = config.getFile()) != null && (path = file.getLocation()) != null) {
            return path.toOSString();
        }
        return null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return true;
    }
}

