/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;

public class BranchNotificationIndication
extends CDOClientIndication {
    public BranchNotificationIndication(CDOClientProtocol protocol) {
        super(protocol, (short)39);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        InternalCDOBranchManager branchManager = this.getSession().getBranchManager();
        InternalCDOBranch firstBranch = null;
        CDOBranchChangedEvent.ChangeKind changeKind = (CDOBranchChangedEvent.ChangeKind)in.readEnum(CDOBranchChangedEvent.ChangeKind.class);
        int size = in.readXInt();
        int[] branchIDs = new int[size];
        int i = 0;
        while (i < size) {
            int branchID;
            branchIDs[i] = branchID = in.readXInt();
            if (firstBranch == null) {
                firstBranch = branchManager.getBranch(branchID);
            }
            if (changeKind == CDOBranchChangedEvent.ChangeKind.RENAMED) {
                String name = in.readString();
                firstBranch.basicSetName(name);
                break;
            }
            ++i;
        }
        branchManager.handleBranchChanged(firstBranch, changeKind, branchIDs);
    }
}

