/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class InvertEqualsFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<InvertEqualsFixOperation> operations = new ArrayList<InvertEqualsFixOperation>();
        InvertEqualsFinder finder = new InvertEqualsFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new InvertEqualsFixCore(FixMessages.InvertEqualsFix_invert, compilationUnit, ops);
    }

    protected InvertEqualsFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class InvertEqualsFinder
    extends ASTVisitor {
        private List<InvertEqualsFixOperation> fResult;

        public InvertEqualsFinder(List<InvertEqualsFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(MethodInvocation visited) {
            Expression expression = visited.getExpression();
            InfixExpression concatenation = ASTNodes.as(expression, InfixExpression.class);
            if (expression == null || ASTNodes.is(expression, ThisExpression.class) || InvertEqualsFinder.isConstant(expression) || concatenation != null && ASTNodes.hasOperator(concatenation, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) && ASTNodes.hasType((Expression)concatenation, String.class.getCanonicalName())) {
                return true;
            }
            if (ASTNodes.usesGivenSignature(visited, Object.class.getCanonicalName(), "equals", Object.class.getCanonicalName()) || ASTNodes.usesGivenSignature(visited, String.class.getCanonicalName(), "equalsIgnoreCase", String.class.getCanonicalName())) {
                Expression arg0 = (Expression)visited.arguments().get(0);
                InfixExpression concatenationArgument = ASTNodes.as(arg0, InfixExpression.class);
                if (InvertEqualsFinder.isConstant(arg0) && arg0.resolveTypeBinding() != null && !arg0.resolveTypeBinding().isPrimitive() || ASTNodes.is(arg0, ThisExpression.class) || concatenationArgument != null && ASTNodes.hasOperator(concatenationArgument, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) && ASTNodes.hasType((Expression)concatenationArgument, String.class.getCanonicalName())) {
                    this.fResult.add(new InvertEqualsFixOperation(expression, arg0));
                    return false;
                }
            }
            return true;
        }

        private static boolean isConstant(Expression expression) {
            IBinding binding;
            if (expression != null && expression.resolveConstantExpressionValue() != null) {
                return true;
            }
            if (expression instanceof Name && (binding = ((Name)expression).resolveBinding()) instanceof IVariableBinding) {
                return ((IVariableBinding)binding).isEnumConstant();
            }
            return false;
        }
    }

    public static class InvertEqualsFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final Expression expression;
        private final Expression arg0;

        public InvertEqualsFixOperation(Expression expression, Expression arg0) {
            this.expression = expression;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.InvertEqualsCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.expression, (ASTNode)ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, this.arg0)), group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.arg0, (ASTNode)ASTNodes.createMoveTarget(rewrite, ASTNodes.getUnparenthesedExpression(this.expression)), group);
        }
    }
}

