/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session.remote;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.session.remote.CDORemoteTopic;
import org.eclipse.emf.cdo.session.remote.CDORemoteTopicEvent;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSession;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDORemoteTopic;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;

public class CDORemoteTopicImpl
extends Container<CDORemoteSession>
implements InternalCDORemoteTopic {
    private final InternalCDORemoteSessionManager manager;
    private final String id;
    private final Set<Integer> remoteSessionIDs;

    public CDORemoteTopicImpl(InternalCDORemoteSessionManager manager, String id, Set<Integer> remoteSessionIDs) {
        this.manager = manager;
        this.id = id;
        this.remoteSessionIDs = remoteSessionIDs;
    }

    @Override
    public InternalCDORemoteSessionManager getManager() {
        return this.manager;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public InternalCDORemoteSession[] getRemoteSessions() {
        List<CDORemoteSession> remoteSessions = this.getRemoteSessionsList();
        return remoteSessions.toArray(new InternalCDORemoteSession[remoteSessions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CDORemoteSession> getRemoteSessionsList() {
        ArrayList<CDORemoteSession> remoteSessions = new ArrayList<CDORemoteSession>();
        Set<Integer> set = this.remoteSessionIDs;
        synchronized (set) {
            for (Integer remoteSessionID : this.remoteSessionIDs) {
                InternalCDORemoteSession remoteSession = this.manager.getRemoteSession(remoteSessionID);
                if (remoteSession == null) continue;
                remoteSessions.add(remoteSession);
            }
        }
        return remoteSessions;
    }

    @Override
    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage message) {
        List<CDORemoteSession> recipients = this.getRemoteSessionsList();
        CDOSessionProtocol sessionProtocol = this.manager.getLocalSession().getSessionProtocol();
        Set<Integer> sessionIDs = sessionProtocol.sendRemoteMessage(message, this, recipients);
        HashSet<CDORemoteSession> result = new HashSet<CDORemoteSession>();
        for (CDORemoteSession recipient : recipients) {
            if (!sessionIDs.contains(recipient.getSessionID())) continue;
            result.add(recipient);
        }
        return result;
    }

    public CDORemoteSession[] getElements() {
        return this.getRemoteSessions();
    }

    @Override
    public boolean isSubscribed() {
        return this.manager.getSubscribedTopic(this.id) != null;
    }

    @Override
    public void unsubscribe() {
        this.manager.unsubscribeTopic(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoteSessionSubscribed(int sessionID, boolean subscribed) {
        Set<Integer> set = this.remoteSessionIDs;
        synchronized (set) {
            if (subscribed) {
                this.remoteSessionIDs.add(sessionID);
            } else {
                this.remoteSessionIDs.remove(sessionID);
            }
        }
        InternalCDORemoteSession remoteSession = this.manager.getRemoteSession(sessionID);
        if (remoteSession != null) {
            this.fireContainerEvent(remoteSession, subscribed ? IContainerDelta.Kind.ADDED : IContainerDelta.Kind.REMOVED);
        }
    }

    @Override
    public void handleRemoteSessionMessage(InternalCDORemoteSession remoteSession, CDORemoteSessionMessage message) {
        this.fireEvent(new MessageReceivedImpl(remoteSession, message));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.manager == null ? 0 : this.manager.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CDORemoteTopicImpl other = (CDORemoteTopicImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.manager == null ? other.manager != null : !this.manager.equals(other.manager));
    }

    @Override
    public int compareTo(CDORemoteTopic o) {
        return this.id.compareTo(o.getID());
    }

    public String toString() {
        return this.id;
    }

    private final class MessageReceivedImpl
    extends Event
    implements CDORemoteTopicEvent.MessageReceived {
        private static final long serialVersionUID = 1L;
        private final InternalCDORemoteSession remoteSession;
        private final CDORemoteSessionMessage message;

        public MessageReceivedImpl(InternalCDORemoteSession remoteSession, CDORemoteSessionMessage message) {
            super((INotifier)CDORemoteTopicImpl.this);
            this.remoteSession = remoteSession;
            this.message = message;
        }

        @Override
        public CDORemoteTopic getSource() {
            return (CDORemoteTopic)super.getSource();
        }

        @Override
        public CDORemoteSession getRemoteSession() {
            return this.remoteSession;
        }

        @Override
        public CDORemoteSessionMessage getMessage() {
            return this.message;
        }
    }
}

