/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TaskListBackupManager;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TaskDataExportWizardPage
extends WizardPage {
    private static final String PAGE_ID = "org.eclipse.mylyn.tasklist.exportPage";
    private Button browseButton = null;
    private Text destDirText = null;
    private static final String SETTINGS_SAVED = "Settings saved";
    private static final String DEST_DIR_SETTING = "Destination directory setting";

    public TaskDataExportWizardPage() {
        super(PAGE_ID);
        this.setPageComplete(false);
        this.setImageDescriptor(CommonImages.BANNER_EXPORT);
        this.setTitle(Messages.TaskDataExportWizardPage_Export_Mylyn_Task_Data);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createExportDirectoryControl(container);
        this.initSettings();
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        this.setPageComplete(this.validate());
    }

    private void createExportDirectoryControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(768));
        new Label(parent, 0).setText(Messages.TaskDataExportWizardPage_File);
        Label l = new Label(parent, 0);
        l.setText(TaskListBackupManager.getBackupFileName());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        new Label(parent, 0).setText(Messages.TaskDataExportWizardPage_Folder);
        this.destDirText = new Text(parent, 2048);
        this.destDirText.setEditable(false);
        this.destDirText.setLayoutData((Object)new GridData(768));
        this.destDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskDataExportWizardPage.this.controlChanged();
            }
        });
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText(Messages.TaskDataExportWizardPage_Browse_);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TaskDataExportWizardPage.this.getShell());
                dialog.setText(Messages.TaskDataExportWizardPage_Folder_Selection);
                dialog.setMessage(Messages.TaskDataExportWizardPage_Specify_the_destination_folder_for_task_data);
                String dir = TaskDataExportWizardPage.this.destDirText.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TaskDataExportWizardPage.this.destDirText.setText(dir);
                TaskDataExportWizardPage.this.controlChanged();
            }
        });
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(SETTINGS_SAVED) == null) {
            this.destDirText.setText("");
        } else {
            String directory = settings.get(DEST_DIR_SETTING);
            if (directory != null) {
                this.destDirText.setText(settings.get(DEST_DIR_SETTING));
            }
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(DEST_DIR_SETTING, this.destDirText.getText());
        settings.put(SETTINGS_SAVED, SETTINGS_SAVED);
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        this.setMessage(null);
        if (this.destDirText.getText().equals("")) {
            this.setMessage(Messages.TaskDataExportWizardPage_Please_choose_an_export_destination, 2);
            return false;
        }
        return true;
    }

    public String getDestinationDirectory() {
        return this.destDirText.getText();
    }

    public void setDestinationDirectory(String destinationDir) {
        this.destDirText.setText(destinationDir);
    }
}

