/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.uml2.uml.Element;

public class BehaviorSymbolEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static String BEHAVIOR_SYMBOL = "BehaviorSymbolEditPolicy";

    public void notifyChanged(Notification notification) {
        int eventType;
        View behaviorSymbol = this.getView();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)behaviorSymbol);
        if (this.getUMLElement() == null) {
            this.executeBehaviorSymbolDeletion(domain, behaviorSymbol);
        }
        if (((eventType = notification.getEventType()) == 4 || eventType == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getView_Visible())) && this.getView() != null && this.getPortNode() == null) {
            this.executeBehaviorSymbolDeletion(domain, behaviorSymbol);
        }
    }

    protected Node getPortNode() {
        View SemanticView = (View)this.getHost().getModel();
        Edge behaviorPortLink = null;
        for (Edge edge : SemanticView.getTargetEdges()) {
            if (!"Port_BehaviorEdge".equals(edge.getType())) continue;
            behaviorPortLink = edge;
        }
        if (behaviorPortLink == null) {
            return null;
        }
        return (Node)behaviorPortLink.getSource();
    }

    protected Element getUMLElement() {
        if ((Element)this.getView().getElement() != null) {
            return (Element)this.getView().getElement();
        }
        return null;
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.getPortNode() != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)this.getPortNode(), (NotificationListener)this);
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.getPortNode() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)this.getPortNode(), (NotificationListener)this);
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    protected void executeBehaviorSymbolDeletion(final TransactionalEditingDomain domain, final View commentNode) {
        try {
            if (domain != null) {
                domain.runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        if (commentNode != null && TransactionUtil.getEditingDomain((EObject)commentNode) != null) {
                            DeleteCommand command = new DeleteCommand(commentNode);
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

