/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import java.util.List;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.IWrappableStructuredViewer;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractStructuredViewerWrapper<C extends Control, V extends IWrappableStructuredViewer>
extends StructuredViewer {
    private final V fViewer;
    private final C fControl;
    private final EMFCompareConfiguration fConfiguration;
    private final ISelectionChangedListener fWrappedViewerSelectionChangedListener;
    private final HelpListener fWrappedViewerHelpListener;
    private final IDoubleClickListener fWrappedViewerDoubleClickListener;
    private final ISelectionChangedListener fWrappedViewerPostSelectionChangedListener;
    private final IOpenListener fWrappedViewerOpenListener;

    public AbstractStructuredViewerWrapper(Composite parent, EMFCompareConfiguration compareConfiguration) {
        this.fConfiguration = compareConfiguration;
        this.preHookCreateControlAndViewer();
        ControlAndViewer<C, V> cv = this.createControlAndViewer(parent);
        this.fControl = cv.getControl();
        this.fViewer = cv.getViewer();
        this.hookControl((Control)this.fControl);
        this.fWrappedViewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractStructuredViewerWrapper.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractStructuredViewerWrapper.this, event.getSelection()));
            }
        };
        this.fViewer.addSelectionChangedListener(this.fWrappedViewerSelectionChangedListener);
        this.fWrappedViewerHelpListener = new HelpListener(){

            public void helpRequested(HelpEvent e) {
                Event event = new Event();
                event.widget = AbstractStructuredViewerWrapper.this.fControl;
                event.display = e.display;
                event.widget = e.widget;
                event.time = e.time;
                event.data = e.data;
                AbstractStructuredViewerWrapper.this.fireHelpRequested(new HelpEvent(event));
            }
        };
        this.fViewer.addHelpListener(this.fWrappedViewerHelpListener);
        this.fWrappedViewerDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof TreeSelection && ((TreeSelection)event.getSelection()).getFirstElement() instanceof GroupItemProviderAdapter && AbstractStructuredViewerWrapper.this.fViewer instanceof TreeViewer) {
                    GroupItemProviderAdapter groupItem = (GroupItemProviderAdapter)((TreeSelection)event.getSelection()).getFirstElement();
                    ((TreeViewer)AbstractStructuredViewerWrapper.this.fViewer).expandToLevel((Object)groupItem, 2);
                } else {
                    AbstractStructuredViewerWrapper.this.fireDoubleClick(new DoubleClickEvent((Viewer)AbstractStructuredViewerWrapper.this, event.getSelection()));
                }
            }
        };
        this.fViewer.addDoubleClickListener(this.fWrappedViewerDoubleClickListener);
        this.fWrappedViewerPostSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractStructuredViewerWrapper.this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractStructuredViewerWrapper.this, event.getSelection()));
            }
        };
        this.fViewer.addPostSelectionChangedListener(this.fWrappedViewerPostSelectionChangedListener);
        this.fWrappedViewerOpenListener = new IOpenListener(){

            public void open(OpenEvent event) {
                if (!(event.getSelection() instanceof TreeSelection && ((TreeSelection)event.getSelection()).getFirstElement() instanceof GroupItemProviderAdapter && AbstractStructuredViewerWrapper.this.fViewer instanceof TreeViewer)) {
                    AbstractStructuredViewerWrapper.this.fireOpen(new OpenEvent((Viewer)AbstractStructuredViewerWrapper.this, event.getSelection()));
                }
            }
        };
        this.fViewer.addOpenListener(this.fWrappedViewerOpenListener);
    }

    protected final EMFCompareConfiguration getCompareConfiguration() {
        return this.fConfiguration;
    }

    protected void preHookCreateControlAndViewer() {
    }

    protected abstract ControlAndViewer<C, V> createControlAndViewer(Composite var1);

    public final C getControl() {
        return this.fControl;
    }

    protected final V getViewer() {
        return this.fViewer;
    }

    protected void handleDispose(DisposeEvent event) {
        this.fViewer.removeOpenListener(this.fWrappedViewerOpenListener);
        this.fViewer.removePostSelectionChangedListener(this.fWrappedViewerPostSelectionChangedListener);
        this.fViewer.removeDoubleClickListener(this.fWrappedViewerDoubleClickListener);
        this.fViewer.removeSelectionChangedListener(this.fWrappedViewerSelectionChangedListener);
        this.fViewer.removeHelpListener(this.fWrappedViewerHelpListener);
        super.handleDispose(event);
    }

    public final void setContentProvider(IContentProvider provider) {
        this.fViewer.setContentProvider(provider);
        super.setContentProvider(provider);
    }

    public final void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fViewer.setLabelProvider(labelProvider);
        super.setLabelProvider(labelProvider);
    }

    public final void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        this.fViewer.addDragSupport(operations, transferTypes, listener);
    }

    public final void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        this.fViewer.addDropSupport(operations, transferTypes, listener);
    }

    protected final Widget doFindInputItem(Object element) {
        return this.fViewer.doFindInputItem(element);
    }

    protected final Widget doFindItem(Object element) {
        return this.fViewer.doFindInputItem(element);
    }

    protected final void doUpdateItem(Widget item, Object element, boolean fullMap) {
        this.fViewer.doUpdateItem(item, element, fullMap);
    }

    public final IElementComparer getComparer() {
        return this.fViewer.getComparer();
    }

    public final void addFilter(ViewerFilter filter) {
        this.fViewer.addFilter(filter);
        super.addFilter(filter);
    }

    public final ViewerFilter[] getFilters() {
        return this.fViewer.getFilters();
    }

    public final void removeFilter(ViewerFilter filter) {
        this.fViewer.removeFilter(filter);
        super.removeFilter(filter);
    }

    public final void setFilters(ViewerFilter[] filters) {
        this.fViewer.setFilters(filters);
        super.setFilters(filters);
    }

    public final void resetFilters() {
        this.fViewer.resetFilters();
        super.resetFilters();
    }

    public final void reveal(Object element) {
        this.fViewer.reveal(element);
    }

    protected final List getSelectionFromWidget() {
        return this.fViewer.getSelectionFromWidget();
    }

    public final ViewerSorter getSorter() {
        return this.fViewer.getSorter();
    }

    public final ViewerComparator getComparator() {
        return this.fViewer.getComparator();
    }

    protected final void setSelectionToWidget(List l, boolean reveal) {
        this.fViewer.setSelectionToWidget(l, reveal);
    }

    protected final void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        this.fViewer.handleInvalidSelection(invalidSelection, newSelection);
    }

    public final void setSorter(ViewerSorter sorter) {
        this.fViewer.setSorter(sorter);
        super.setSorter(sorter);
    }

    public final void setComparator(ViewerComparator comparator) {
        this.fViewer.setComparator(comparator);
        super.setComparator(comparator);
    }

    public final void setUseHashlookup(boolean enable) {
        this.fViewer.setUseHashlookup(enable);
    }

    public final void setComparer(IElementComparer comparer) {
        this.fViewer.setComparer(comparer);
    }

    public static final class ControlAndViewer<C extends Control, V extends IWrappableStructuredViewer> {
        private final C control;
        private final V viewer;

        private ControlAndViewer(C control, V viewer) {
            this.control = control;
            this.viewer = viewer;
        }

        public C getControl() {
            return this.control;
        }

        public V getViewer() {
            return this.viewer;
        }

        public static <C extends Control, V extends IWrappableStructuredViewer> ControlAndViewer<C, V> create(C control, V viewer) {
            return new ControlAndViewer<C, V>(control, viewer);
        }
    }
}

