/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.provider.AbstractPasteInSelectionNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.InsertedElementInNattable;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class PasteInSelectionNattableCommandProvider
extends AbstractPasteInSelectionNattableCommandProvider {
    protected PasteEObjectConfiguration pasteConfigurationTopLevel = null;

    public PasteInSelectionNattableCommandProvider(INattableModelManager tableManager, boolean pasteColumn, boolean isInsert, Reader reader, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper, int preferredUserAction, long totalSize) {
        super(tableManager, pasteColumn, isInsert, reader, pasteHelper, tableSelectionWrapper, preferredUserAction, totalSize);
    }

    @Override
    protected void init() {
        this.detachedMode = this.isPasteInDetachedMode(this.table);
        PasteEObjectConfiguration configuration = this.getPasteconfigurationTopLevel(this.table);
        if (configuration != null) {
            this.postActions = new ArrayList(configuration.getPostActions());
            this.detachedMode = configuration.isDetachedMode();
        }
    }

    @Override
    protected PasteEObjectConfiguration getPasteconfigurationTopLevel(Table table) {
        if (this.pasteConfigurationTopLevel == null) {
            this.pasteConfigurationTopLevel = this.pasteColumn ? (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), true) : (PasteEObjectConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(this.table, NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), false);
        }
        return this.pasteConfigurationTopLevel;
    }

    @Override
    protected PasteEObjectConfiguration getPasteConfiguration(Table table, int currentDepth, String categoryName) {
        return this.getPasteconfigurationTopLevel(table);
    }

    @Override
    protected int getDepthFromObject(Object object) {
        return 0;
    }

    @Override
    protected String getCategoryFromObject(Object object) {
        return "";
    }

    @Override
    protected Object getRowElementCreatedInAttachedMode(EObject context, EStructuralFeature containmentFeature, IElementType typeToCreate, IProgressMonitor monitor, IAdaptable info, CompoundCommand compoundCommand) {
        Object createdElement = null;
        if (!containmentFeature.isDerived() && containmentFeature.isChangeable()) {
            CreateElementRequest createRequest = new CreateElementRequest(this.contextEditingDomain, context, typeToCreate, (EReference)containmentFeature);
            IElementEditService tableContextCommandProvider = ElementEditServiceUtils.getCommandProvider((EObject)context);
            ICommand commandCreation = tableContextCommandProvider.getEditCommand((IEditCommandRequest)createRequest);
            if (commandCreation.canExecute()) {
                Command emfCommandCreation = GMFtoEMFCommandWrapper.wrap((ICommand)commandCreation);
                emfCommandCreation.execute();
                compoundCommand.append(emfCommandCreation);
                CommandResult res = commandCreation.getCommandResult();
                createdElement = res.getReturnValue();
            }
        }
        return createdElement;
    }

    @Override
    protected void createTableRowInAttachedModeCommand(CompoundCommand compoundCommand, List<InsertedElementInNattable> createdElements) throws ExecutionException {
        CompoundCommand addCommand = new CompoundCommand("Create table row");
        int insertedElementIndex = createdElements.size() - 1;
        while (insertedElementIndex >= 0) {
            InsertedElementInNattable currentInsertedElement = createdElements.get(insertedElementIndex);
            if (-1 != currentInsertedElement.getIndexInParent()) {
                int addedIndex = 0;
                for (Object createdElement : currentInsertedElement.getCreatedElements()) {
                    addCommand.append(MoveCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), (Object)createdElement, (int)(currentInsertedElement.getIndexInParent() + addedIndex)));
                    ++addedIndex;
                }
            }
            --insertedElementIndex;
        }
        for (InsertedElementInNattable currentInsertedElement : createdElements) {
            if (-1 != currentInsertedElement.getIndexInTable()) {
                if (this.pasteColumn) {
                    Command addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                    if (!addColumnElementCommand.canExecute()) continue;
                    addCommand.append(addColumnElementCommand);
                    continue;
                }
                Command addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                if (!addRowElementCommand.canExecute()) continue;
                addCommand.append(addRowElementCommand);
                continue;
            }
            if (this.pasteColumn) {
                Command addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements());
                if (!addColumnElementCommand.canExecute()) continue;
                addCommand.append(addColumnElementCommand);
                continue;
            }
            Command addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements());
            if (!addRowElementCommand.canExecute()) continue;
            addCommand.append(addRowElementCommand);
        }
        if (!addCommand.isEmpty()) {
            compoundCommand.append((Command)addCommand);
        }
    }

    @Override
    protected Object getRowElementCreatedInDetachedMode(EStructuralFeature containmentFeature, IElementType typeToCreate, IProgressMonitor monitor, IAdaptable info, CompoundCommand compoundCommand) {
        EObject result = null;
        if (!containmentFeature.isDerived() && containmentFeature.isChangeable()) {
            EClass eClassToCreate = typeToCreate.getEClass();
            EFactory eFactory = eClassToCreate.getEPackage().getEFactoryInstance();
            result = eFactory.create(eClassToCreate);
        }
        return result;
    }

    @Override
    protected void createTableRowInDetachedModeCommand(CompoundCommand compoundCommand, List<InsertedElementInNattable> createdElements) throws ExecutionException {
        CompoundCommand addCommand = new CompoundCommand("Create table row");
        int insertedElementIndex = createdElements.size() - 1;
        while (insertedElementIndex >= 0) {
            InsertedElementInNattable currentInsertedElement = createdElements.get(insertedElementIndex);
            if (currentInsertedElement.getContainementFeature().isMany()) {
                if (-1 != currentInsertedElement.getIndexInParent()) {
                    addCommand.append(AddCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), currentInsertedElement.getCreatedElements(), (int)currentInsertedElement.getIndexInParent()));
                } else {
                    addCommand.append(AddCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), currentInsertedElement.getCreatedElements()));
                }
            } else {
                addCommand.append(SetCommand.create((EditingDomain)this.contextEditingDomain, (Object)currentInsertedElement.getContext(), (Object)currentInsertedElement.getContainementFeature(), (Object)currentInsertedElement.getCreatedElements().get(0)));
            }
            --insertedElementIndex;
        }
        for (InsertedElementInNattable currentInsertedElement : createdElements) {
            Command addRowElementCommand;
            Command addColumnElementCommand;
            if (-1 != currentInsertedElement.getIndexInTable()) {
                if (this.pasteColumn) {
                    addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                    if (!addColumnElementCommand.canExecute()) continue;
                    addCommand.append(addColumnElementCommand);
                    continue;
                }
                addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements(), currentInsertedElement.getIndexInTable());
                if (!addRowElementCommand.canExecute()) continue;
                addCommand.append(addRowElementCommand);
                continue;
            }
            if (this.pasteColumn) {
                addColumnElementCommand = this.tableManager.getAddColumnElementCommand(currentInsertedElement.getCreatedElements());
                if (!addColumnElementCommand.canExecute()) continue;
                addCommand.append(addColumnElementCommand);
                continue;
            }
            addRowElementCommand = this.tableManager.getAddRowElementCommand(currentInsertedElement.getCreatedElements());
            if (!addRowElementCommand.canExecute()) continue;
            addCommand.append(addRowElementCommand);
        }
        if (!addCommand.isEmpty()) {
            compoundCommand.append((Command)addCommand);
        }
    }

    @Override
    protected void localDispose() {
        super.localDispose();
        this.pasteConfigurationTopLevel = null;
    }

    @Override
    protected Object getColumnElement(int realColumnIndex) {
        return this.tableManager.getColumnElementsList().get(realColumnIndex);
    }
}

