/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridLayout
extends AbstractHintLayout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    protected Map constraints = new HashMap();

    public GridLayout() {
    }

    public GridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        return child.getPreferredSize(wHint, hHint);
    }

    GridData getData(IFigure[][] grid, int row, int column, int rowCount, int columnCount, boolean first) {
        IFigure figure = grid[row][column];
        if (figure != null) {
            int j;
            GridData data = (GridData)this.getConstraint(figure);
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            int i = first ? row + vSpan - 1 : row - vSpan + 1;
            int n = j = first ? column + hSpan - 1 : column - hSpan + 1;
            if (i >= 0 && i < rowCount && j >= 0 && j < columnCount && figure == grid[i][j]) {
                return data;
            }
        }
        return null;
    }

    void initChildren(IFigure container) {
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child.getLayoutManager() == null) {
                child.setLayoutManager(this);
            }
            ++i;
        }
    }

    @Override
    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int borderWidth = container.getInsets().getWidth();
        int borderHeight = container.getInsets().getHeight();
        if (wHint != -1) {
            wHint -= borderWidth;
        }
        if (hHint != -1) {
            hHint -= borderHeight;
        }
        Dimension size = this.layout(container, false, 0, 0, wHint, hHint, true);
        if (wHint != -1) {
            size.width = wHint;
        }
        if (hHint != -1) {
            size.height = hHint;
        }
        size.expand(borderWidth, borderHeight);
        size.union(this.getBorderPreferredSize(container));
        return size;
    }

    @Override
    public void layout(IFigure container) {
        Rectangle rect = container.getClientArea();
        this.layout(container, true, rect.x, rect.y, rect.width, rect.height, true);
    }

    Dimension layout(IFigure container, boolean move, int x, int y, int width, int height, boolean flushCache) {
        int k;
        int k2;
        int i;
        int k3;
        int last;
        int remainder;
        int i2;
        int j;
        if (this.numColumns < 1) {
            return new Dimension(this.marginWidth * 2, this.marginHeight * 2);
        }
        List children = container.getChildren();
        int i3 = 0;
        while (i3 < children.size()) {
            IFigure child = (IFigure)children.get(i3);
            GridData data = (GridData)this.getConstraint(child);
            if (data == null) {
                data = new GridData();
                this.setConstraint(child, data);
            }
            if (flushCache) {
                data.flushCache();
            }
            data.computeSize(child, flushCache);
            ++i3;
        }
        int row = 0;
        int column = 0;
        int rowCount = 0;
        int columnCount = this.numColumns;
        IFigure[][] grid = new IFigure[4][columnCount];
        int i4 = 0;
        while (i4 < children.size()) {
            IFigure child = (IFigure)children.get(i4);
            GridData data = (GridData)this.getConstraint(child);
            int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
            int vSpan = Math.max(1, data.verticalSpan);
            while (true) {
                int lastRow;
                if ((lastRow = row + vSpan) >= grid.length) {
                    IFigure[][] newGrid = new IFigure[lastRow + 4][columnCount];
                    System.arraycopy(grid, 0, newGrid, 0, grid.length);
                    grid = newGrid;
                }
                if (grid[row] == null) {
                    grid[row] = new IFigure[columnCount];
                }
                while (column < columnCount && grid[row][column] != null) {
                    ++column;
                }
                int endCount = column + hSpan;
                if (endCount <= columnCount) {
                    int index = column;
                    while (index < endCount && grid[row][index] == null) {
                        ++index;
                    }
                    if (index == endCount) break;
                    column = index;
                }
                if (column + hSpan < columnCount) continue;
                column = 0;
                ++row;
            }
            j = 0;
            while (j < vSpan) {
                if (grid[row + j] == null) {
                    grid[row + j] = new IFigure[columnCount];
                }
                int k4 = 0;
                while (k4 < hSpan) {
                    grid[row + j][column + k4] = child;
                    ++k4;
                }
                ++j;
            }
            rowCount = Math.max(rowCount, row + vSpan);
            column += hSpan;
            ++i4;
        }
        int availableWidth = width - this.horizontalSpacing * (columnCount - 1) - this.marginWidth * 2;
        int expandCount = 0;
        int[] widths = new int[columnCount];
        int[] minWidths = new int[columnCount];
        boolean[] expandColumn = new boolean[columnCount];
        j = 0;
        while (j < columnCount) {
            int hSpan;
            i2 = 0;
            while (i2 < rowCount) {
                GridData data = this.getData(grid, i2, j, rowCount, columnCount, true);
                if (data != null && (hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount))) == 1) {
                    int w = data.cacheWidth + data.horizontalIndent;
                    widths[j] = Math.max(widths[j], w);
                    if (data.grabExcessHorizontalSpace) {
                        if (!expandColumn[j]) {
                            ++expandCount;
                        }
                        expandColumn[j] = true;
                    }
                    if (data.widthHint != -1 || !data.grabExcessHorizontalSpace) {
                        minWidths[j] = Math.max(minWidths[j], w);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < rowCount) {
                GridData data = this.getData(grid, i2, j, rowCount, columnCount, false);
                if (data != null && (hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount))) > 1) {
                    int delta;
                    int w;
                    int spanWidth = 0;
                    int spanMinWidth = 0;
                    int spanExpandCount = 0;
                    int k5 = 0;
                    while (k5 < hSpan) {
                        spanWidth += widths[j - k5];
                        spanMinWidth += minWidths[j - k5];
                        if (expandColumn[j - k5]) {
                            ++spanExpandCount;
                        }
                        ++k5;
                    }
                    if (data.grabExcessHorizontalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandColumn[j] = true;
                    }
                    if ((w = data.cacheWidth + data.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = j;
                            widths[n] = widths[n] + w;
                        } else {
                            delta = w / spanExpandCount;
                            remainder = w % spanExpandCount;
                            last = -1;
                            k3 = 0;
                            while (k3 < hSpan) {
                                if (expandColumn[j - k3]) {
                                    last = j - k3;
                                    widths[last] = widths[last] + delta;
                                }
                                ++k3;
                            }
                            if (last > -1) {
                                int n = last;
                                widths[n] = widths[n] + remainder;
                            }
                        }
                    }
                    if (!(data.widthHint == -1 && data.grabExcessHorizontalSpace || (w = data.cacheWidth + data.horizontalIndent - spanMinWidth - (hSpan - 1) * this.horizontalSpacing) <= 0)) {
                        if (spanExpandCount == 0) {
                            int n = j;
                            minWidths[n] = minWidths[n] + w;
                        } else {
                            delta = w / spanExpandCount;
                            remainder = w % spanExpandCount;
                            last = -1;
                            k3 = 0;
                            while (k3 < hSpan) {
                                if (expandColumn[j - k3]) {
                                    last = j - k3;
                                    minWidths[last] = minWidths[last] + delta;
                                }
                                ++k3;
                            }
                            if (last > -1) {
                                int n = last;
                                minWidths[n] = minWidths[n] + remainder;
                            }
                        }
                    }
                }
                ++i2;
            }
            ++j;
        }
        if (this.makeColumnsEqualWidth) {
            int minColumnWidth = 0;
            int columnWidth = 0;
            int i5 = 0;
            while (i5 < columnCount) {
                minColumnWidth = Math.max(minColumnWidth, minWidths[i5]);
                columnWidth = Math.max(columnWidth, widths[i5]);
                ++i5;
            }
            columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math.max(minColumnWidth, availableWidth / columnCount);
            i5 = 0;
            while (i5 < columnCount) {
                expandColumn[i5] = expandCount > 0;
                widths[i5] = columnWidth;
                ++i5;
            }
        } else if (width != -1 && expandCount > 0) {
            int totalWidth = 0;
            i2 = 0;
            while (i2 < columnCount) {
                totalWidth += widths[i2];
                ++i2;
            }
            int count = expandCount;
            int delta = (availableWidth - totalWidth) / count;
            int remainder2 = (availableWidth - totalWidth) % count;
            int last2 = -1;
            while (totalWidth != availableWidth) {
                int j2 = 0;
                while (j2 < columnCount) {
                    if (expandColumn[j2]) {
                        if (widths[j2] + delta > minWidths[j2]) {
                            last2 = j2;
                            widths[last2] = widths[j2] + delta;
                        } else {
                            widths[j2] = minWidths[j2];
                            expandColumn[j2] = false;
                            --count;
                        }
                    }
                    ++j2;
                }
                if (last2 > -1) {
                    int n = last2;
                    widths[n] = widths[n] + remainder2;
                }
                j2 = 0;
                while (j2 < columnCount) {
                    i = 0;
                    while (i < rowCount) {
                        int hSpan;
                        GridData data = this.getData(grid, i, j2, rowCount, columnCount, false);
                        if (!(data == null || (hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount))) <= 1 || data.widthHint == -1 && data.grabExcessHorizontalSpace)) {
                            int spanWidth = 0;
                            int spanExpandCount = 0;
                            k3 = 0;
                            while (k3 < hSpan) {
                                spanWidth += widths[j2 - k3];
                                if (expandColumn[j2 - k3]) {
                                    ++spanExpandCount;
                                }
                                ++k3;
                            }
                            int w = data.cacheWidth + data.horizontalIndent - spanWidth - (hSpan - 1) * this.horizontalSpacing;
                            if (w > 0) {
                                if (spanExpandCount == 0) {
                                    int n = j2;
                                    widths[n] = widths[n] + w;
                                } else {
                                    int delta2 = w / spanExpandCount;
                                    int remainder22 = w % spanExpandCount;
                                    int last22 = -1;
                                    k2 = 0;
                                    while (k2 < hSpan) {
                                        if (expandColumn[j2 - k2]) {
                                            last22 = j2 - k2;
                                            widths[last22] = widths[last22] + delta2;
                                        }
                                        ++k2;
                                    }
                                    if (last22 > -1) {
                                        int n = last22;
                                        widths[n] = widths[n] + remainder22;
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    ++j2;
                }
                if (count != 0) {
                    totalWidth = 0;
                    int i6 = 0;
                    while (i6 < columnCount) {
                        totalWidth += widths[i6];
                        ++i6;
                    }
                    delta = (availableWidth - totalWidth) / count;
                    remainder2 = (availableWidth - totalWidth) % count;
                    last2 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] flush = null;
        int flushLength = 0;
        if (width != -1) {
            int j3 = 0;
            while (j3 < columnCount) {
                int i7 = 0;
                while (i7 < rowCount) {
                    GridData data = this.getData(grid, i7, j3, rowCount, columnCount, false);
                    if (data != null && data.heightHint == -1) {
                        IFigure child = grid[i7][j3];
                        int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
                        int currentWidth = 0;
                        int k6 = 0;
                        while (k6 < hSpan) {
                            currentWidth += widths[j3 - k6];
                            ++k6;
                        }
                        if ((currentWidth += (hSpan - 1) * this.horizontalSpacing - data.horizontalIndent) != data.cacheWidth && data.horizontalAlignment == 4 || data.cacheWidth > currentWidth) {
                            int trim = 0;
                            int oldWidthHint = data.widthHint;
                            data.widthHint = Math.max(0, currentWidth - trim);
                            data.cacheHeight = -1;
                            data.cacheWidth = -1;
                            data.computeSize(child, false);
                            data.widthHint = oldWidthHint;
                            if (flush == null) {
                                flush = new GridData[children.size()];
                            }
                            flush[flushLength++] = data;
                        }
                    }
                    ++i7;
                }
                ++j3;
            }
        }
        int availableHeight = height - this.verticalSpacing * (rowCount - 1) - this.marginHeight * 2;
        expandCount = 0;
        int[] heights = new int[rowCount];
        int[] minHeights = new int[rowCount];
        boolean[] expandRow = new boolean[rowCount];
        i = 0;
        while (i < rowCount) {
            int vSpan;
            int j4 = 0;
            while (j4 < columnCount) {
                GridData data = this.getData(grid, i, j4, rowCount, columnCount, true);
                if (data != null && (vSpan = Math.max(1, Math.min(data.verticalSpan, rowCount))) == 1) {
                    int h = data.cacheHeight;
                    heights[i] = Math.max(heights[i], h);
                    if (data.grabExcessVerticalSpace) {
                        if (!expandRow[i]) {
                            ++expandCount;
                        }
                        expandRow[i] = true;
                    }
                    if (data.heightHint != -1 || !data.grabExcessVerticalSpace) {
                        minHeights[i] = Math.max(minHeights[i], h);
                    }
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < columnCount) {
                GridData data = this.getData(grid, i, j4, rowCount, columnCount, false);
                if (data != null && (vSpan = Math.max(1, Math.min(data.verticalSpan, rowCount))) > 1) {
                    int last3;
                    int remainder3;
                    int delta;
                    int h;
                    int spanHeight = 0;
                    int spanMinHeight = 0;
                    int spanExpandCount = 0;
                    int k7 = 0;
                    while (k7 < vSpan) {
                        spanHeight += heights[i - k7];
                        spanMinHeight += minHeights[i - k7];
                        if (expandRow[i - k7]) {
                            ++spanExpandCount;
                        }
                        ++k7;
                    }
                    if (data.grabExcessVerticalSpace && spanExpandCount == 0) {
                        ++expandCount;
                        expandRow[i] = true;
                    }
                    if ((h = data.cacheHeight - spanHeight - (vSpan - 1) * this.verticalSpacing) > 0) {
                        if (spanExpandCount == 0) {
                            int n = i;
                            heights[n] = heights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder3 = h % spanExpandCount;
                            last3 = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i - k]) {
                                    last3 = i - k;
                                    heights[last3] = heights[last3] + delta;
                                }
                                ++k;
                            }
                            if (last3 > -1) {
                                int n = last3;
                                heights[n] = heights[n] + remainder3;
                            }
                        }
                    }
                    if (!(data.heightHint == -1 && data.grabExcessVerticalSpace || (h = data.cacheHeight - spanMinHeight - (vSpan - 1) * this.verticalSpacing) <= 0)) {
                        if (spanExpandCount == 0) {
                            int n = i;
                            minHeights[n] = minHeights[n] + h;
                        } else {
                            delta = h / spanExpandCount;
                            remainder3 = h % spanExpandCount;
                            last3 = -1;
                            k = 0;
                            while (k < vSpan) {
                                if (expandRow[i - k]) {
                                    last3 = i - k;
                                    minHeights[last3] = minHeights[last3] + delta;
                                }
                                ++k;
                            }
                            if (last3 > -1) {
                                int n = last3;
                                minHeights[n] = minHeights[n] + remainder3;
                            }
                        }
                    }
                }
                ++j4;
            }
            ++i;
        }
        if (height != -1 && expandCount > 0) {
            int totalHeight = 0;
            int i8 = 0;
            while (i8 < rowCount) {
                totalHeight += heights[i8];
                ++i8;
            }
            int count = expandCount;
            int delta = (availableHeight - totalHeight) / count;
            remainder = (availableHeight - totalHeight) % count;
            last = -1;
            while (totalHeight != availableHeight) {
                int i9 = 0;
                while (i9 < rowCount) {
                    if (expandRow[i9]) {
                        if (heights[i9] + delta > minHeights[i9]) {
                            last = i9;
                            heights[last] = heights[i9] + delta;
                        } else {
                            heights[i9] = minHeights[i9];
                            expandRow[i9] = false;
                            --count;
                        }
                    }
                    ++i9;
                }
                if (last > -1) {
                    int n = last;
                    heights[n] = heights[n] + remainder;
                }
                i9 = 0;
                while (i9 < rowCount) {
                    int j5 = 0;
                    while (j5 < columnCount) {
                        int vSpan;
                        GridData data = this.getData(grid, i9, j5, rowCount, columnCount, false);
                        if (!(data == null || (vSpan = Math.max(1, Math.min(data.verticalSpan, rowCount))) <= 1 || data.heightHint == -1 && data.grabExcessVerticalSpace)) {
                            int spanHeight = 0;
                            int spanExpandCount = 0;
                            k = 0;
                            while (k < vSpan) {
                                spanHeight += heights[i9 - k];
                                if (expandRow[i9 - k]) {
                                    ++spanExpandCount;
                                }
                                ++k;
                            }
                            int h = data.cacheHeight - spanHeight - (vSpan - 1) * this.verticalSpacing;
                            if (h > 0) {
                                if (spanExpandCount == 0) {
                                    int n = i9;
                                    heights[n] = heights[n] + h;
                                } else {
                                    int delta2 = h / spanExpandCount;
                                    int remainder2 = h % spanExpandCount;
                                    int last2 = -1;
                                    int k8 = 0;
                                    while (k8 < vSpan) {
                                        if (expandRow[i9 - k8]) {
                                            last2 = i9 - k8;
                                            heights[last2] = heights[last2] + delta2;
                                        }
                                        ++k8;
                                    }
                                    if (last2 > -1) {
                                        int n = last2;
                                        heights[n] = heights[n] + remainder2;
                                    }
                                }
                            }
                        }
                        ++j5;
                    }
                    ++i9;
                }
                if (count == 0) break;
                totalHeight = 0;
                i9 = 0;
                while (i9 < rowCount) {
                    totalHeight += heights[i9];
                    ++i9;
                }
                delta = (availableHeight - totalHeight) / count;
                remainder = (availableHeight - totalHeight) % count;
                last = -1;
            }
        }
        if (move) {
            int gridY = y + this.marginHeight;
            int i10 = 0;
            while (i10 < rowCount) {
                int gridX = x + this.marginWidth;
                int j6 = 0;
                while (j6 < columnCount) {
                    GridData data = this.getData(grid, i10, j6, rowCount, columnCount, true);
                    if (data != null) {
                        int hSpan = Math.max(1, Math.min(data.horizontalSpan, columnCount));
                        int vSpan = Math.max(1, data.verticalSpan);
                        int cellWidth = 0;
                        int cellHeight = 0;
                        k2 = 0;
                        while (k2 < hSpan) {
                            cellWidth += widths[j6 + k2];
                            ++k2;
                        }
                        k2 = 0;
                        while (k2 < vSpan) {
                            cellHeight += heights[i10 + k2];
                            ++k2;
                        }
                        int childX = gridX + data.horizontalIndent;
                        int childWidth = Math.min(data.cacheWidth, cellWidth += this.horizontalSpacing * (hSpan - 1));
                        switch (data.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childX = gridX + Math.max(0, (cellWidth - childWidth) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                childX = gridX + Math.max(0, cellWidth - childWidth);
                                break;
                            }
                            case 4: {
                                childWidth = cellWidth - data.horizontalIndent;
                            }
                        }
                        int childY = gridY;
                        int childHeight = Math.min(data.cacheHeight, cellHeight += this.verticalSpacing * (vSpan - 1));
                        switch (data.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                childY = gridY + Math.max(0, (cellHeight - childHeight) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                childY = gridY + Math.max(0, cellHeight - childHeight);
                                break;
                            }
                            case 4: {
                                childHeight = cellHeight;
                            }
                        }
                        IFigure child = grid[i10][j6];
                        if (child != null) {
                            child.setBounds(new Rectangle(childX, childY, childWidth, childHeight));
                        }
                    }
                    gridX += widths[j6] + this.horizontalSpacing;
                    ++j6;
                }
                gridY += heights[i10] + this.verticalSpacing;
                ++i10;
            }
        }
        i = 0;
        while (i < flushLength) {
            flush[i].cacheHeight = -1;
            flush[i].cacheWidth = -1;
            ++i;
        }
        int totalDefaultWidth = 0;
        int totalDefaultHeight = 0;
        int i11 = 0;
        while (i11 < columnCount) {
            totalDefaultWidth += widths[i11];
            ++i11;
        }
        i11 = 0;
        while (i11 < rowCount) {
            totalDefaultHeight += heights[i11];
            ++i11;
        }
        return new Dimension(totalDefaultWidth += this.horizontalSpacing * (columnCount - 1) + this.marginWidth * 2, totalDefaultHeight += this.verticalSpacing * (rowCount - 1) + this.marginHeight * 2);
    }

    @Override
    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    @Override
    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }
}

