/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.util.PDESchemaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ButtonAttributeRow;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class IdAttributeRow
extends ButtonAttributeRow {
    public IdAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    @Override
    protected boolean isReferenceModel() {
        return !this.part.getPage().getModel().isEditable();
    }

    @Override
    protected void browse() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new IdAttributeLabelProvider());
        dialog.setTitle(PDEUIMessages.IdAttributeRow_title);
        dialog.setMessage(PDEUIMessages.IdAttributeRow_message);
        dialog.setEmptyListMessage(PDEUIMessages.IdAttributeRow_emptyMessage);
        Map attributeMap = PDESchemaHelper.getValidAttributes((ISchemaAttribute)this.getAttribute());
        dialog.setElements(attributeMap.entrySet().toArray());
        dialog.setFilter("*");
        if (dialog.open() == 0) {
            Map.Entry entry = (Map.Entry)dialog.getFirstResult();
            this.text.setText((String)entry.getKey());
        }
    }

    @Override
    protected void openReference() {
        String pluginId;
        IPluginModelBase model;
        IEditorPart editorPart;
        ManifestEditor editor;
        String id;
        Map attributeMap = PDESchemaHelper.getValidAttributes((ISchemaAttribute)this.getAttribute());
        IConfigurationElement element = (IConfigurationElement)attributeMap.get(id = this.text.getText());
        if (element != null && (editor = (ManifestEditor)(editorPart = ManifestEditor.open((model = PluginRegistry.findModel((String)(pluginId = element.getContributor().getName()))).getPluginBase(), true))) != null) {
            InputContext context = editor.getContextManager().findContext("plugin-context");
            IDocument document = context.getDocumentProvider().getDocument((Object)context.getInput());
            IRegion region = ManifestEditorOpener.getAttributeMatch(editor, id, document);
            if (region == null) {
                id = id.substring(id.lastIndexOf(46) + 1, id.length());
                region = ManifestEditorOpener.getAttributeMatch(editor, id, document);
            }
            editor.openToSourcePage(context, region.getOffset(), region.getLength());
        }
    }

    private class IdAttributeLabelProvider
    extends LabelProvider {
        private IdAttributeLabelProvider() {
        }

        public Image getImage(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_GENERIC_XML_OBJ);
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                Object text = (String)entry.getKey();
                IConfigurationElement value = (IConfigurationElement)entry.getValue();
                String name = value.getAttribute("name");
                if (name == null && (name = value.getAttribute("label")) == null) {
                    name = value.getAttribute("description");
                }
                String contributor = value.getContributor().getName();
                if (IdAttributeRow.this.input != null && name != null && name.startsWith("%") && contributor != null) {
                    IPluginModelBase model = PluginRegistry.findModel((String)contributor);
                    name = model.getResourceString(name);
                }
                if (name != null) {
                    text = (String)text + " - " + name;
                }
                if (contributor != null) {
                    text = (String)text + " [" + contributor + "]";
                }
                return text;
            }
            return super.getText(element);
        }
    }
}

