/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class NewAnnotationMemberProposalCore
extends LinkedCorrectionProposalCore {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private final ASTNode fInvocationNode;
    private final ITypeBinding fSenderBinding;

    public NewAnnotationMemberProposalCore(String label, ICompilationUnit targetCU, ASTNode invocationNode, ITypeBinding binding, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance);
        this.fInvocationNode = invocationNode;
        this.fSenderBinding = binding;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.getInvocationNode());
        ASTNode typeDecl = astRoot.findDeclaringNode((IBinding)this.getSenderBinding());
        ASTNode newTypeDecl = null;
        if (typeDecl != null) {
            newTypeDecl = typeDecl;
        } else {
            astRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            newTypeDecl = astRoot.findDeclaringNode(this.getSenderBinding().getKey());
        }
        this.createImportRewrite(astRoot);
        if (newTypeDecl instanceof AnnotationTypeDeclaration) {
            AnnotationTypeDeclaration newAnnotationTypeDecl = (AnnotationTypeDeclaration)newTypeDecl;
            ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
            AnnotationTypeMemberDeclaration newStub = this.getStub(rewrite, newAnnotationTypeDecl);
            List members = newAnnotationTypeDecl.bodyDeclarations();
            int insertIndex = members.size();
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)newAnnotationTypeDecl, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            listRewriter.insertAt((ASTNode)newStub, insertIndex, null);
            return rewrite;
        }
        return null;
    }

    private AnnotationTypeMemberDeclaration getStub(ASTRewrite rewrite, AnnotationTypeDeclaration targetTypeDecl) {
        AST ast = targetTypeDecl.getAST();
        AnnotationTypeMemberDeclaration decl = ast.newAnnotationTypeMemberDeclaration();
        SimpleName newNameNode = this.getNewName(rewrite);
        decl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.evaluateModifiers(targetTypeDecl)));
        ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, decl.modifiers(), true);
        decl.setName(newNameNode);
        Type returnType = this.getNewType(rewrite);
        decl.setType(returnType);
        return decl;
    }

    private Type getNewType(ASTRewrite rewrite) {
        AST ast = rewrite.getAST();
        SimpleType newTypeNode = null;
        ITypeBinding binding = null;
        if (this.getInvocationNode().getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            Expression value = ((MemberValuePair)this.getInvocationNode().getParent()).getValue();
            binding = value.resolveTypeBinding();
        } else if (this.getInvocationNode() instanceof Expression) {
            binding = ((Expression)this.getInvocationNode()).resolveTypeBinding();
        }
        if (binding != null) {
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(this.getInvocationNode(), this.getImportRewrite());
            newTypeNode = this.getImportRewrite().addImport(binding, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.RETURN_TYPE);
        }
        if (newTypeNode == null) {
            newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("String"));
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        return newTypeNode;
    }

    private int evaluateModifiers(AnnotationTypeDeclaration targetTypeDecl) {
        List methodDecls = targetTypeDecl.bodyDeclarations();
        for (BodyDeclaration curr : methodDecls) {
            if (!(curr instanceof AnnotationTypeMemberDeclaration)) continue;
            return ((AnnotationTypeMemberDeclaration)curr).getModifiers();
        }
        return 0;
    }

    private SimpleName getNewName(ASTRewrite rewrite) {
        String name;
        AST ast = rewrite.getAST();
        if (this.getInvocationNode().getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            name = ((SimpleName)this.getInvocationNode()).getIdentifier();
            if (ast == this.getInvocationNode().getAST()) {
                this.addLinkedPosition(rewrite.track(this.getInvocationNode()), true, KEY_NAME);
            }
        } else {
            name = "value";
        }
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)newNameNode), false, KEY_NAME);
        return newNameNode;
    }

    public ASTNode getInvocationNode() {
        return this.fInvocationNode;
    }

    public ITypeBinding getSenderBinding() {
        return this.fSenderBinding;
    }
}

