/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionRangeOperations {
    protected CollectionRangeOperations() {
    }

    public static <C> boolean checkRangeType(CollectionRange<C> collectionRange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(collectionRange, context);
        if (env != null) {
            Object type = collectionRange.getType();
            OCLExpression<C> first = collectionRange.getFirst();
            OCLExpression<C> last = collectionRange.getLast();
            if (type != null && first.getType() != null && last.getType() != null) {
                Object partsType = TypeUtil.commonSuperType(null, env, first.getType(), last.getType());
                boolean bl = result = partsType != null && TypeUtil.exactTypeMatch(env, partsType, type);
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 8, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkRangeType", EObjectValidator.getObjectLabel(collectionRange, context)}), new Object[]{collectionRange}));
        }
        return result;
    }
}

