/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.sheet.chooser;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.diagram.common.sheet.chooser.ElementChooserPage;
import org.eclipse.uml2.diagram.common.sheet.chooser.TabbedElementChooser;

public class ReferencedElementChooserDialog
extends TrayDialog {
    public static final Object NULL_VALUE = new String("Null EObject");
    private static final int UNSET_BUTTON_ID = 22;
    public Object myResult;
    private final EStructuralFeature myFeature;
    private AdapterFactoryLabelProvider labelProvider;
    private final EObject mySourceObject;
    protected TabbedElementChooser myChooser;
    protected final TransactionalEditingDomain myEditingDomain;

    public ReferencedElementChooserDialog(Shell shell, IDialogSettings settings, AdapterFactory itemProvidersAdapterFactory, EObject sourceObject, EStructuralFeature feature) {
        super(shell);
        this.mySourceObject = sourceObject;
        this.myFeature = feature;
        this.labelProvider = new AdapterFactoryLabelProvider(itemProvidersAdapterFactory);
        this.myEditingDomain = TransactionUtil.getEditingDomain((EObject)sourceObject);
        this.myChooser = new TabbedElementChooser(settings, itemProvidersAdapterFactory, sourceObject, feature, this.myEditingDomain);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.myChooser.createDialogArea(composite);
        this.myChooser.addSelectionListener(new OkButtonEnabler());
        return composite;
    }

    public void create() {
        super.create();
        this.myChooser.initSelection();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 22, "Unset", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)"Choose {0} for {1}", (Object[])new Object[]{this.myFeature.getName(), this.labelProvider.getText((Object)this.mySourceObject)}));
        shell.setImage(this.labelProvider.getImage((Object)this.mySourceObject));
    }

    protected void buttonPressed(int buttonId) {
        if (22 == buttonId) {
            this.unsetPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void unsetPressed() {
        this.myResult = NULL_VALUE;
        this.close();
    }

    protected void okPressed() {
        List<?> selection = this.myChooser.getSelection();
        if (!selection.isEmpty()) {
            URI uri = EcoreUtil.getURI((EObject)((EObject)selection.get(0)));
            this.myResult = this.myEditingDomain.getResourceSet().getEObject(uri, true);
        }
        super.okPressed();
    }

    public Object getResult() {
        return this.myResult;
    }

    private void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    private class OkButtonEnabler
    implements ISelectionChangedListener {
        ElementChooserPage.Validator myValidator;

        private OkButtonEnabler() {
            this.myValidator = ReferencedElementChooserDialog.this.myChooser.getValidator();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            List<?> selection = ReferencedElementChooserDialog.this.myChooser.getSelection();
            if (selection.size() == 1) {
                Object firstSelected = selection.get(0);
                ReferencedElementChooserDialog.this.setOkButtonEnabled(this.myValidator.validate(firstSelected) != null);
            } else {
                ReferencedElementChooserDialog.this.setOkButtonEnabled(false);
            }
        }
    }
}

