/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.rdf.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.eodm.rdf.rdfbase.PlainLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFGraph;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.RDFXMLLiteral;
import org.eclipse.eodm.rdf.rdfbase.TypedLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfweb.Document;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserIOException;
import org.eclipse.eodm.util.Triple;

class RDFXMLSaverImpl {
    protected Writer writer;
    protected int indentLevel;
    protected boolean isElementStarting;
    protected String elementType;
    protected RDFGraph graph;
    protected Hashtable NamespaceHashTable = new Hashtable();

    protected void writeIndents() {
        int len = this.indentLevel;
        while (len-- > 0) {
            try {
                this.writer.write("\t");
            }
            catch (IOException e) {
                throw new ParserIOException("IO exception: " + e.getMessage());
            }
        }
    }

    protected void writeElementStart(Triple triple) {
        try {
            this.writeIndents();
            this.writer.write("<" + this.elementType + " " + this.getIDAttrString(triple, true, false) + ">\n");
            ++this.indentLevel;
        }
        catch (IOException e) {
            throw new ParserIOException("IO exception: " + e.getMessage());
        }
    }

    protected void writeElementEnding() {
        --this.indentLevel;
        try {
            this.writeIndents();
            this.writer.write("</" + this.elementType + ">\n");
        }
        catch (IOException e) {
            throw new ParserIOException("IO exception: " + e.getMessage());
        }
    }

    protected void writeElementStarting(Triple triple) {
        if (this.isElementStarting) {
            this.isElementStarting = false;
            this.writeElementStart(triple);
        }
    }

    protected void writeStatement(Triple triple) {
        String propertyName = this.getQName(triple.getPredicateUriRef(), false);
        try {
            this.writeIndents();
            this.writer.write("<" + propertyName);
            if (triple.isObjectLiteral()) {
                PlainLiteral plainLiteral;
                String lang;
                RDFSLiteral literal = triple.getObjectLiteral();
                if (literal instanceof RDFXMLLiteral) {
                    this.writer.write(" rdf:parseType=\"Literal\">");
                    this.writer.write(this.replaceKeywords(literal.getLexicalForm()));
                    this.writer.write("\n");
                    this.writeIndents();
                    this.writer.write("</" + propertyName + ">\n");
                    return;
                }
                if (literal instanceof TypedLiteral) {
                    String datatypeURI = ((TypedLiteral)literal).getDatatypeURI().getURIString();
                    this.writer.write(" rdf:datatype=\"" + datatypeURI + "\">");
                    this.writer.write(this.replaceKeywords(literal.getLexicalForm()));
                    this.writer.write("</" + propertyName + ">\n");
                    return;
                }
                if (literal instanceof PlainLiteral && (lang = (plainLiteral = (PlainLiteral)literal).getLanguage()) != null && lang.length() > 0) {
                    this.writer.write(" xml:lang=\"" + lang + "\"");
                }
                this.writer.write(">" + this.replaceKeywords(literal.getLexicalForm()));
                this.writer.write("</" + propertyName + ">\n");
                return;
            }
            if (triple.isObjectBlankNode()) {
                this.writer.write(" rdf:nodeID=\"" + triple.getObjectNodeID() + "\"/>\n");
            } else {
                this.writer.write(" " + this.getIDAttrString(triple, false, true) + "/>\n");
            }
        }
        catch (IOException e) {
            throw new ParserIOException("Parser IO Exception: " + e.getMessage());
        }
    }

    protected String getQName(URIReference uri, boolean isEntityRef) {
        String namespace = null;
        if (uri.getNamespace() != null) {
            namespace = this.getNamespaceAbbr(uri.getNamespace().getNamespaceURIRef().getURIString());
        }
        if (isEntityRef) {
            if (namespace != null) {
                System.out.println("&" + namespace + ";" + this.replaceKeywords(uri.getFragmentIdentifier().getName()));
                return "&" + namespace + ";" + this.replaceKeywords(uri.getFragmentIdentifier().getName());
            }
            if (uri.getURIString().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
                return "&" + this.getNamespaceAbbr("http://www.w3.org/1999/02/22-rdf-syntax-ns#") + ";" + uri.getURIString().substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length(), uri.getURIString().length());
            }
            if (uri.getURIString().startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
                return "&" + this.getNamespaceAbbr("http://www.w3.org/2000/01/rdf-schema#") + ";" + uri.getURIString().substring("http://www.w3.org/2000/01/rdf-schema#".length(), uri.getURIString().length());
            }
            return this.replaceKeywords(uri.getURIString());
        }
        if (namespace != null) {
            System.out.println(String.valueOf(namespace) + ":" + this.replaceKeywords(uri.getFragmentIdentifier().getName()));
            return String.valueOf(namespace) + ":" + this.replaceKeywords(uri.getFragmentIdentifier().getName());
        }
        if (uri.getURIString().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            return String.valueOf(this.getNamespaceAbbr("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) + ":" + uri.getURIString().substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length(), uri.getURIString().length());
        }
        if (uri.getURIString().startsWith("http://www.w3.org/2000/01/rdf-schema#")) {
            return String.valueOf(this.getNamespaceAbbr("http://www.w3.org/2000/01/rdf-schema#")) + ":" + uri.getURIString().substring("http://www.w3.org/2000/01/rdf-schema#".length(), uri.getURIString().length());
        }
        return this.replaceKeywords(uri.getURIString());
    }

    protected String getIDAttrString(Triple triple, boolean sub, boolean isPropAttr) {
        if (sub) {
            if (triple.getSubjectNodeID() != null) {
                return "rdf:nodeID=\"" + triple.getSubjectNodeID() + "\"";
            }
            String leftSide = isPropAttr ? "rdf:resource=" : "rdf:about=";
            return String.valueOf(leftSide) + "\"" + this.getQName(triple.getSubjectUriRef(), true) + "\"";
        }
        if (triple.getObjectNodeID() != null) {
            return "rdf:nodeID=\"" + triple.getSubjectNodeID() + "\"";
        }
        String leftSide = isPropAttr ? "rdf:resource=" : "rdf:about=";
        return String.valueOf(leftSide) + "\"" + this.getQName(triple.getObjectUriRef(), true) + "\"";
    }

    public RDFXMLSaverImpl(Writer writer, Document document) {
        this.writer = writer;
        this.isElementStarting = false;
        this.indentLevel = 0;
        this.elementType = "";
        this.graph = document.getComplementalGraph();
        Iterator iter = document.getNamespaceDefinition().iterator();
        while (iter.hasNext()) {
            NamespaceDefinition namespace = (NamespaceDefinition)iter.next();
            this.NamespaceHashTable.put(namespace.getNamespace().getNamespaceURIRef().getURIString(), namespace.getNamespacePrefix());
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/2000/01/rdf-schema#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        }
        if (this.NamespaceHashTable.get("http://www.w3.org/2001/XMLSchema#") == null) {
            this.NamespaceHashTable.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        }
    }

    public String getNamespaceAbbr(String uri) {
        String abbr = (String)this.NamespaceHashTable.get(uri);
        if (abbr == null) {
            return null;
        }
        return abbr;
    }

    public void save() {
        ArrayList triples = this.graph.exportTriples();
        String subjectURI = null;
        String currentURI = null;
        ArrayList<Triple> object = new ArrayList<Triple>();
        Iterator iterator = triples.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            if (subjectURI == null) {
                subjectURI = triple.isSubjectURI() ? triple.getSubjectURI() : triple.getSubjectNodeID();
            }
            if (subjectURI.equals(currentURI = triple.isSubjectURI() ? triple.getSubjectURI() : triple.getSubjectNodeID())) {
                object.add(triple);
                continue;
            }
            this.saveResource(object);
            object.clear();
            subjectURI = currentURI;
            object.add(triple);
        }
        this.saveResource(object);
        object.clear();
    }

    protected void saveResource(ArrayList triples) {
        this.indentLevel = 0;
        this.isElementStarting = true;
        URIReference type = null;
        Triple typeTriple = null;
        int number = 0;
        Iterator iterator = triples.iterator();
        while (iterator.hasNext()) {
            Triple triple = (Triple)iterator.next();
            if (!triple.getPredicate().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") || triple.getObjectURI().equals("http://www.w3.org/2000/01/rdf-schema#Resource")) continue;
            type = triple.getObjectUriRef();
            ++number;
            typeTriple = triple;
        }
        if (number == 1) {
            this.elementType = this.getQName(type, false);
            this.writeElementStarting(typeTriple);
            triples.remove(typeTriple);
            iterator = triples.iterator();
            while (iterator.hasNext()) {
                this.writeStatement((Triple)iterator.next());
            }
            this.writeElementEnding();
        } else {
            this.elementType = "rdf:Description";
            iterator = triples.iterator();
            this.writeElementStarting((Triple)iterator.next());
            iterator = triples.iterator();
            while (iterator.hasNext()) {
                this.writeStatement((Triple)iterator.next());
            }
            this.writeElementEnding();
        }
    }

    private String replaceKeywords(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "&apos;");
        str = str.replaceAll("\"", "&quot;");
        return str;
    }
}

