/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.valuespec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueSpecificationParser
implements ISemanticParser {
    private static final Set<EStructuralFeature> ourFeatures;
    private static final String BODIES_SEPARATOR;

    static {
        BODIES_SEPARATOR = String.valueOf(System.getProperty("line.separator")) + System.getProperty("line.separator");
        HashSet<EAttribute> features = new HashSet<EAttribute>();
        features.add(UMLPackage.eINSTANCE.getLiteralInteger_Value());
        features.add(UMLPackage.eINSTANCE.getLiteralString_Value());
        features.add(UMLPackage.eINSTANCE.getExpression_Symbol());
        features.add(UMLPackage.eINSTANCE.getOpaqueExpression_Body());
        ourFeatures = Collections.unmodifiableSet(features);
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return this.isAffectingEvent(notification, 0);
    }

    public boolean isAffectingEvent(Object notification, int flags) {
        if (notification instanceof Notification) {
            Object feature = ((Notification)notification).getFeature();
            return ourFeatures.contains(feature);
        }
        return false;
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        if (element == null || !(element instanceof ValueSpecification)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        ValueSpecification specification = this.getValueSpecification(element);
        if (specification == null) {
            return "";
        }
        UMLSwitch<String> valueSwitch = new UMLSwitch<String>(){

            public String caseLiteralString(LiteralString object) {
                return object.getValue();
            }

            public String caseLiteralInteger(LiteralInteger object) {
                return Integer.toString(object.getValue());
            }

            public String caseExpression(Expression object) {
                return object.getSymbol();
            }

            public String caseOpaqueExpression(OpaqueExpression object) {
                StringBuilder result = new StringBuilder();
                for (String nextBody : object.getBodies()) {
                    if (nextBody == null) continue;
                    if (result.length() > 0) {
                        result.append(BODIES_SEPARATOR);
                    }
                    result.append(nextBody);
                }
                return result.toString();
            }

            public String defaultCase(EObject object) {
                return "";
            }
        };
        return (String)valueSwitch.doSwitch((EObject)specification);
    }

    public ICommand getParseCommand(IAdaptable element, final String newString, int flags) {
        final ValueSpecification vs = this.getValueSpecification(element);
        if (vs == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (newString == null) {
            return UnexecutableCommand.INSTANCE;
        }
        UMLSwitch<ICommand> valueSwitch = new UMLSwitch<ICommand>(){

            public ICommand caseLiteralString(LiteralString object) {
                EAttribute feature = UMLPackage.eINSTANCE.getLiteralString_Value();
                return new SetValueCommand(new SetRequest((EObject)vs, (EStructuralFeature)feature, (Object)newString));
            }

            public ICommand caseLiteralInteger(LiteralInteger object) {
                try {
                    Integer intValue = Integer.parseInt(newString);
                    EAttribute feature = UMLPackage.eINSTANCE.getLiteralInteger_Value();
                    return new SetValueCommand(new SetRequest((EObject)vs, (EStructuralFeature)feature, (Object)intValue));
                }
                catch (NumberFormatException numberFormatException) {
                    return UnexecutableCommand.INSTANCE;
                }
            }

            public ICommand caseExpression(Expression object) {
                EAttribute feature = UMLPackage.eINSTANCE.getExpression_Symbol();
                return new SetValueCommand(new SetRequest((EObject)vs, (EStructuralFeature)feature, (Object)newString));
            }

            public ICommand caseOpaqueExpression(OpaqueExpression object) {
                String[] bodies = newString.split("(\\r|\\n|\\u0085|\\u2028|\u2029){2,}");
                ArrayList<String> bodiesList = new ArrayList<String>(bodies.length);
                String[] stringArray = bodies;
                int n = bodies.length;
                int n2 = 0;
                while (n2 < n) {
                    String next = stringArray[n2];
                    if (next != null && next.length() != 0) {
                        bodiesList.add(next);
                    }
                    ++n2;
                }
                return new SetValueCommand(new SetRequest((EObject)vs, (EStructuralFeature)UMLPackage.eINSTANCE.getOpaqueExpression_Body(), bodiesList));
            }

            public ICommand defaultCase(EObject object) {
                return UnexecutableCommand.INSTANCE;
            }
        };
        return (ICommand)valueSwitch.doSwitch((EObject)vs);
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    protected ValueSpecification getValueSpecification(IAdaptable adaptable) {
        return (ValueSpecification)adaptable.getAdapter(EObject.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstraintParser
    extends ValueSpecificationParser {
        @Override
        public boolean isAffectingEvent(Object notification, int flags) {
            if (notification instanceof Notification) {
                Object feature = ((Notification)notification).getFeature();
                return UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature) || super.isAffectingEvent(notification, flags);
            }
            return false;
        }

        @Override
        public List<?> getSemanticElementsBeingParsed(EObject element) {
            if (!(element instanceof Constraint)) {
                return Collections.emptyList();
            }
            ValueSpecification spec = ((Constraint)element).getSpecification();
            return spec == null ? Collections.emptyList() : Collections.singletonList(spec);
        }

        @Override
        protected ValueSpecification getValueSpecification(IAdaptable adaptable) {
            Constraint is = (Constraint)adaptable.getAdapter(EObject.class);
            return is.getSpecification();
        }
    }
}

