/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;

public class BisectionBorderItemLocator
extends BorderItemLocator {
    public BisectionBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public BisectionBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public BisectionBorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        int side = BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)this.getParentBorder());
        return this.getBisectionLocation(super.getValidLocation(proposedLocation, borderItem), side);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        int closestSide = BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)rectSuggested, (Rectangle)this.getParentBorder());
        this.setPreferredSideOfParent(closestSide);
        Point ptNewLocation = this.locateOnBorder(this.getPreferredLocation(borderItem), this.getPreferredSideOfParent(), 0, borderItem);
        this.setCurrentSideOfParent(BisectionBorderItemLocator.findClosestSideOfParent((Rectangle)new Rectangle(ptNewLocation, size), (Rectangle)this.getParentBorder()));
        Rectangle bisectLoc = this.getBisectionLocation(new Rectangle(ptNewLocation, size), this.getCurrentSideOfParent());
        borderItem.setBounds(bisectLoc);
    }

    protected Rectangle getBisectionLocation(Rectangle location, int side) {
        Rectangle bisectingLocation = new Rectangle(location);
        switch (side) {
            case 8: {
                bisectingLocation.x += bisectingLocation.width / 2;
                break;
            }
            case 16: {
                bisectingLocation.x -= bisectingLocation.width / 2;
                break;
            }
            case 1: {
                bisectingLocation.y += bisectingLocation.height / 2;
                break;
            }
            case 4: {
                bisectingLocation.y -= bisectingLocation.height / 2;
            }
        }
        return bisectingLocation;
    }
}

