/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.manage;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsNode;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.gef.AbsDiagramGef;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.SdLayoutModelAddRemoveProcessor;

class UpdateEventAccumulator {
    private final AbsDiagramGef.AbsElementFactory myAbsElementFactory;
    private final ArrayList myEvents = new ArrayList();
    private AsserterRunner myAsserterRunner = AsserterRunner.STUB;

    public UpdateEventAccumulator(AbsDiagramGef.AbsElementFactory absElementFactory, EditPart rootEditPart) {
        this.myAbsElementFactory = absElementFactory;
    }

    public void elementAdded(IGraphicalEditPart element) {
        if (this.isUnsupported(element)) {
            return;
        }
        if (element instanceof ConnectionEditPart) {
            this.myEvents.add(new AddLink((ConnectionEditPart)element));
        } else if (element instanceof GraphicalEditPart) {
            GraphicalEditPart modelNodeEditPart = (GraphicalEditPart)element;
            this.myAsserterRunner.nodeAdded(modelNodeEditPart);
            this.myEvents.add(new AddNode(modelNodeEditPart));
        }
    }

    public void elementRemoved(IGraphicalEditPart element) {
        if (this.isUnsupported(element)) {
            return;
        }
        if (element instanceof ConnectionEditPart) {
            this.myEvents.add(new RemoveLink((ConnectionEditPart)element));
        } else if (element instanceof GraphicalEditPart) {
            GraphicalEditPart modelNodeEditPart = (GraphicalEditPart)element;
            this.myAsserterRunner.nodeRemoved(modelNodeEditPart);
            this.myEvents.add(new RemoveNode(modelNodeEditPart));
        }
    }

    boolean isUnsupported(IGraphicalEditPart element) {
        return element instanceof DiagramEditPart || element instanceof ITextAwareEditPart;
    }

    public void accept(SdLayoutModelAddRemoveProcessor processor) {
        try {
            int i = 0;
            while (i < this.myEvents.size()) {
                ((UpdateEvent)this.myEvents.get(i)).process(processor);
                ++i;
            }
        }
        finally {
            processor.finish();
        }
    }

    public void clear() {
        this.myEvents.clear();
    }

    class AddLink
    extends UpdateEvent {
        final AbsLink myLink;

        AddLink(ConnectionEditPart editPart) {
            this.myLink = UpdateEventAccumulator.this.myAbsElementFactory.createAbsLink(editPart);
        }

        public void process(SdLayoutModelAddRemoveProcessor processor) {
            processor.processAddedGdeLink(this.myLink);
        }
    }

    class AddNode
    extends UpdateEvent {
        final AbsNode myNode;

        AddNode(GraphicalEditPart editPart) {
            this.myNode = UpdateEventAccumulator.this.myAbsElementFactory.createAbsNode(editPart);
        }

        public void process(SdLayoutModelAddRemoveProcessor processor) {
            processor.processAddedGdeNode(this.myNode);
        }
    }

    private static abstract class AsserterRunner {
        static final AsserterRunner STUB = new AsserterRunner(){

            void nodeAdded(GraphicalEditPart nodeEditPart) {
            }

            void nodeRemoved(GraphicalEditPart nodeEditPart) {
            }
        };

        private AsserterRunner() {
        }

        abstract void nodeAdded(GraphicalEditPart var1);

        abstract void nodeRemoved(GraphicalEditPart var1);
    }

    class RemoveLink
    extends UpdateEvent {
        final AbsLink myLink;

        RemoveLink(ConnectionEditPart editPart) {
            this.myLink = UpdateEventAccumulator.this.myAbsElementFactory.createAbsLink(editPart);
        }

        public void process(SdLayoutModelAddRemoveProcessor processor) {
            processor.processRemovedGdeLink(this.myLink);
        }
    }

    class RemoveNode
    extends UpdateEvent {
        final AbsNode myNode;

        RemoveNode(GraphicalEditPart editPart) {
            this.myNode = UpdateEventAccumulator.this.myAbsElementFactory.createAbsNode(editPart);
        }

        public void process(SdLayoutModelAddRemoveProcessor processor) {
            processor.processRemovedGdeNode(this.myNode);
        }
    }

    abstract class UpdateEvent {
        UpdateEvent() {
        }

        public abstract void process(SdLayoutModelAddRemoveProcessor var1);
    }
}

