/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public abstract class AtlModelHandler {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    public static final String AMH_EMF = "EMF";
    private static String[] modelHandlers = null;
    private static Map defaultModelHandlers = new HashMap();

    public static void registerDefaultHandler(String repository, AtlModelHandler handler) {
        defaultModelHandlers.put(repository, handler);
    }

    public static AtlModelHandler getDefault(String repository) {
        AtlModelHandler ret = (AtlModelHandler)defaultModelHandlers.get(repository);
        if (ret == null) {
            if (AMH_EMF.equals(repository)) {
                ret = new AtlEMFModelHandler();
                defaultModelHandlers.put(repository, ret);
            } else {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                if (registry == null) {
                    throw new RuntimeException("Eclipse platform extension registry not found. Dynamic repository lookup does not work outside Eclipse.");
                }
                IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.modelhandler");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                block2: while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        try {
                            if (elements[j].getAttribute("name").equals(repository)) {
                                ret = (AtlModelHandler)elements[j].createExecutableExtension("class");
                                defaultModelHandlers.put(repository, ret);
                                break block2;
                            }
                        }
                        catch (CoreException e) {
                            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (ret == null) {
                throw new RuntimeException("Model handler for " + repository + " not found. You may need to install a model handler plugin.");
            }
        }
        return ret;
    }

    public static String[] getModelHandlers() {
        if (modelHandlers == null) {
            ArrayList<String> mhs = new ArrayList<String>();
            mhs.add(AMH_EMF);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.modelhandler");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    mhs.add(elements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
            modelHandlers = mhs.toArray(new String[0]);
        }
        return modelHandlers;
    }

    public static String getHandlerName(ASMModel model) {
        String ret = null;
        Iterator i = defaultModelHandlers.keySet().iterator();
        while (i.hasNext() && ret == null) {
            String amhName = (String)i.next();
            AtlModelHandler amh = AtlModelHandler.getDefault(amhName);
            if (!amh.isHandling(model)) continue;
            ret = amhName;
        }
        return ret;
    }

    public static AtlModelHandler getHandler(ASMModel model) {
        return (AtlModelHandler)defaultModelHandlers.get(AtlModelHandler.getHandlerName(model));
    }

    public abstract void saveModel(ASMModel var1, IProject var2);

    public abstract void saveModel(ASMModel var1, String var2, IProject var3);

    public abstract void saveModel(ASMModel var1, String var2);

    public abstract void saveModel(ASMModel var1, OutputStream var2);

    public abstract ASMModel getAtl();

    public abstract ASMModel getMof();

    public abstract ASMModel loadModel(String var1, ASMModel var2, InputStream var3);

    public abstract ASMModel newModel(String var1, ASMModel var2);

    public abstract ASMModel newModel(String var1, String var2, ASMModel var3);

    public void disposeOfModel(ASMModel model) {
    }

    public abstract ASMModel getBuiltInMetaModel(String var1);

    public abstract boolean isHandling(ASMModel var1);
}

