/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.impl.PreferenceItemImpl;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceNodeImpl
extends PreferenceItemImpl
implements PreferenceNode {
    protected EList<PreferenceNode> children;
    protected EList<Property> properties;
    protected static final String LOCATION_EDEFAULT = null;

    protected PreferenceNodeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PreferencesPackage.Literals.PREFERENCE_NODE;
    }

    @Override
    public EList<PreferenceNode> getChildren() {
        if (this.children == null) {
            this.children = new EObjectContainmentWithInverseEList(PreferenceNode.class, (InternalEObject)this, 8, 7);
        }
        return this.children;
    }

    @Override
    public PreferenceNode getParent() {
        if (this.eContainerFeatureID() != 7) {
            return null;
        }
        return (PreferenceNode)this.eInternalContainer();
    }

    public NotificationChain basicSetParent(PreferenceNode newParent, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParent, 7, msgs);
        return msgs;
    }

    @Override
    public void setParent(PreferenceNode newParent) {
        if (newParent != this.eInternalContainer() || this.eContainerFeatureID() != 7 && newParent != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParent)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParent != null) {
                msgs = ((InternalEObject)newParent).eInverseAdd((InternalEObject)this, 8, PreferenceNode.class, msgs);
            }
            if ((msgs = this.basicSetParent(newParent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newParent, (Object)newParent));
        }
    }

    @Override
    public EList<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentWithInverseEList(Property.class, (InternalEObject)this, 9, 7);
        }
        return this.properties;
    }

    @Override
    public String getLocation() {
        try {
            Preferences preferences = PreferencesUtil.getPreferences(this, false);
            IPath path = PreferencesUtil.getLocation(preferences);
            return path == null ? null : path.toString();
        }
        catch (BackingStoreException ex) {
            return null;
        }
    }

    @Override
    public PreferenceNode getNode(String name) {
        for (PreferenceNode node : this.getChildren()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public PreferenceNode getNode(URI path) {
        PreferenceNode preferenceNode = this;
        String authority = path.authority();
        if (authority != null) {
            preferenceNode = this.getRoot();
            if (!"".equals(authority)) {
                preferenceNode = preferenceNode.getNode(URI.decode((String)authority));
            }
        }
        if (preferenceNode == null) {
            return null;
        }
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if ((preferenceNode = preferenceNode.getNode(URI.decode((String)segment))) == null) {
                return null;
            }
            ++n2;
        }
        return preferenceNode;
    }

    @Override
    public Property getProperty(String name) {
        for (Property property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Property getProperty(URI path) {
        if (path.segmentCount() == 0) {
            return null;
        }
        PreferenceNode preferenceNode = this.getNode(path.trimSegments(1));
        if (preferenceNode == null) {
            return null;
        }
        return preferenceNode.getProperty(URI.decode((String)path.lastSegment()));
    }

    @Override
    public PreferenceNode getAncestor() {
        PreferenceNode preferenceNode;
        PreferenceNode instancePreferenceNode;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        URI absolutePath = this.getAbsolutePath();
        if (absolutePath == null) {
            return null;
        }
        URI relativePath = this.getRelativePath();
        if (relativePath == null) {
            return null;
        }
        PreferenceNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        boolean matched = false;
        String authority = absolutePath.authority();
        if ("project".equals(authority)) {
            matched = true;
            instancePreferenceNode = root.getNode("instance");
            if (instancePreferenceNode != null && (preferenceNode = instancePreferenceNode.getNode(relativePath)) != null) {
                return preferenceNode;
            }
        }
        if (matched || "instance".equals(authority)) {
            matched = true;
            instancePreferenceNode = root.getNode("configuration");
            if (instancePreferenceNode != null && (preferenceNode = instancePreferenceNode.getNode(relativePath)) != null) {
                return preferenceNode;
            }
        }
        if ((matched || "configuration".equals(authority)) && (instancePreferenceNode = root.getNode("default")) != null && (preferenceNode = instancePreferenceNode.getNode(relativePath)) != null) {
            return preferenceNode;
        }
        if ((matched || "default".equals(authority)) && (instancePreferenceNode = root.getNode("bundle_default")) != null && (preferenceNode = instancePreferenceNode.getNode(relativePath)) != null) {
            return preferenceNode;
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParent((PreferenceNode)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getProperties()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetParent(null, msgs);
            }
            case 8: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 7: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 8, PreferenceNode.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getParent();
            }
            case 8: {
                return this.getChildren();
            }
            case 9: {
                return this.getProperties();
            }
            case 10: {
                return this.getLocation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setParent((PreferenceNode)newValue);
                return;
            }
            case 8: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setParent(null);
                return;
            }
            case 8: {
                this.getChildren().clear();
                return;
            }
            case 9: {
                this.getProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.getParent() != null;
            }
            case 8: {
                return this.children != null && !this.children.isEmpty();
            }
            case 9: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 10: {
                return LOCATION_EDEFAULT == null ? this.getLocation() != null : !LOCATION_EDEFAULT.equals(this.getLocation());
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 2: {
                return this.getNode((String)arguments.get(0));
            }
            case 3: {
                return this.getNode((URI)arguments.get(0));
            }
            case 4: {
                return this.getProperty((String)arguments.get(0));
            }
            case 5: {
                return this.getProperty((URI)arguments.get(0));
            }
            case 6: {
                return this.getAncestor();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        Property property;
        PreferenceNode child;
        String name;
        if (eStructuralFeature == PreferencesPackage.Literals.PREFERENCE_NODE__CHILDREN && (name = (child = (PreferenceNode)eObject).getName()) != null) {
            String encodedName = URI.encodeSegment((String)name, (boolean)false);
            if (encodedName.startsWith("@")) {
                encodedName = "%40" + encodedName.substring(1);
            }
            return encodedName;
        }
        if (eStructuralFeature == PreferencesPackage.Literals.PREFERENCE_NODE__PROPERTIES && (name = (property = (Property)eObject).getName()) != null) {
            return "^" + URI.encodeSegment((String)name, (boolean)false);
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        if (uriFragmentSegment.startsWith("^")) {
            String preferenceNodeName = URI.decode((String)uriFragmentSegment.substring(1));
            return this.getProperty(preferenceNodeName);
        }
        if (!uriFragmentSegment.startsWith("@")) {
            String preferenceNodeName = URI.decode((String)uriFragmentSegment);
            return this.getNode(preferenceNodeName);
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    @Override
    public URI getAbsolutePath() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        PreferenceNode parent = this.getParent();
        if (parent == null) {
            return URI.createHierarchicalURI(null, (String)URI.encodeAuthority((String)name, (boolean)false), null, null, null);
        }
        URI parentAbsolutePath = parent.getAbsolutePath();
        if (parentAbsolutePath == null) {
            return null;
        }
        if ("".equals(parentAbsolutePath.authority())) {
            return URI.createHierarchicalURI(null, (String)URI.encodeAuthority((String)name, (boolean)false), null, null, null);
        }
        return parentAbsolutePath.appendSegment(URI.encodeSegment((String)name, (boolean)false));
    }

    @Override
    public URI getRelativePath() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        PreferenceNode scope = this.getScope();
        if (this == scope) {
            return URI.createURI((String)"");
        }
        URI parentRelativePath = this.getParent().getRelativePath();
        if (parentRelativePath == null) {
            return null;
        }
        return parentRelativePath.appendSegment(URI.encodeSegment((String)name, (boolean)false));
    }

    @Override
    public PreferenceNode getScope() {
        PreferenceNode result = this;
        PreferenceNode parent = this.getParent();
        while (parent != null) {
            PreferenceNode greatGrandParent;
            PreferenceNode grandParent = parent.getParent();
            if (grandParent == null || (greatGrandParent = grandParent.getParent()) == null && "project".equals(parent.getName())) break;
            result = parent;
            parent = grandParent;
        }
        return result;
    }
}

