/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.net.URI;
import java.util.Optional;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class LinkedResourceDecorator
implements ILightweightLabelDecorator {
    private static final Optional<ImageDescriptor> LINK = ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/link_ovr.png");
    private static final Optional<ImageDescriptor> LINK_WARNING = ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/linkwarn_ovr.png");

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IResource)) {
            return;
        }
        IResource resource = (IResource)element;
        if (resource.isLinked() && !resource.isVirtual()) {
            IFileInfo fileInfo = null;
            URI location = resource.getLocationURI();
            if (location != null) {
                fileInfo = IDEResourceInfoUtils.getFileInfo(location);
            }
            if (fileInfo != null && fileInfo.exists()) {
                LINK.ifPresent(arg_0 -> ((IDecoration)decoration).addOverlay(arg_0));
            } else {
                LINK_WARNING.ifPresent(arg_0 -> ((IDecoration)decoration).addOverlay(arg_0));
            }
        }
    }
}

